<?php


namespace App;


use App\Repositories\Interfaces\DocumentRelationInterface;
use Illuminate\Database\Eloquent\Model;

class Article extends Model implements DocumentRelationInterface
{
    public function documents()
    {
        return $this->morphMany(Document::class, 'attachable');
    }

    public function variables(){
        return $this->hasMany(ArticleVariable::class);
    }
}