<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Support\Facades\Storage;

class Client extends Model {

    # User des Mandanten zurückgeben
    public function user() {
        return $this->hasMany(User::class);
    }

    # Bearbeiter des Mandanten zurückgeben
    public function operator() {
        return $this->hasMany(Operator::class)->orderBy('name');
    }

    public function operatorsWithUser() {
        return $this->hasMany(Operator::class)->where('user_id', '<>', NULL)->orderBy('name');
    }

    # Aufträge
    public function orders() {
        return $this->hasMany(Orders::class);
    }

    # Auftragstypen
    public function order_types() {
        return $this->hasMany(OrderTypes::class);
    }

    # Auftragskennzeichen
    public function order_tags() {
        return $this->hasMany(OrderTags::class);
    }

    # Auftragsstatus
    public function order_status() {
        return $this->hasMany(OrderStatus::class);
    }

    # Bezahlstatus
    public function order_payment_status() {
        return $this->hasMany(OrderPaymentStatus::class);
    }

    # Auftraggeber
    public function customer() {
        return $this->hasMany(Customer::class)->orderBy('company');
    }

    # Textbausteine
    public function textblocks() {
        return $this->hasMany(Textblock::class);
    }

    public function textblocksOrderMail() {
        return $this->hasMany(Textblock::class)->where("type", "=", Textblock::TEXTBLOCKTYPE_ORDERMAIL);
    }

    public function textblockAppointmentMail() {
        return $this->hasOne(Textblock::class)->where("type", "=", Textblock::TEXTBLOCKTYPE_APPOINTMENTMAIL);
    }

    # Alle Nummernkreise
    public function numberRanges() {
        return $this->hasMany(NumberRanges::class);
    }

    # Nummernkreis für Auftragsnummern
    public function numberRangeOrders() {
        return $this->hasOne(NumberRanges::class)->where("key", "=", "order_number");
    }

    # Nummernkreis für Auftraggebernummern
    public function numberRangeCustomers() {
        return $this->hasOne(NumberRanges::class)->where("key", "=", "customer_number");
    }

    # Nummernkreis für Rechnungsnummern
    public function numberRangeOrderInvoices() {
        return $this->hasOne(NumberRanges::class)->where("key", "=", "order_invoice_number");
    }

    # Logo-Datei des Mandanten mit vollständigem Pfad zurückgeben
    public function getLogoImage() {
        if ($this->logo == NULL) $img = "dummy.png";
        else $img = $this->logo;

        $path = Storage::disk("uploads")->url("clients/logos/") . $img;

        return $path;
    }
}
