<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel {
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule) {
        # Dropzone: Übrig gebliebene emporäre Dateien löschen
        $schedule->command('powerkom:dropzoneClearTmpFiles')
            ->weekly();

        # Übrig gebliebene User-Token aus Datenbanktabelle löschen
        $schedule->command('powerkom:userTokenClear')
            ->weekly();

        # Übrig gebliebene Client-Token aus Datenbanktabelle löschen
        $schedule->command('powerkom:clientTokenClear')
            ->weekly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands() {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
