<?php


namespace App;


use App\Http\Controllers\UploadController;
use App\Repositories\DocumentBaseRepository;
use App\Repositories\Interfaces\DocumentRelationInterface;
use Illuminate\Database\Eloquent\Model;

class Document extends Model
{
    # Document Revision List
    public function document_revisions() {
//        return $this->belongsToMany(DocumentRevision::class, 'document_revisions', 'document_id');
        return $this->hasMany(DocumentRevision::class);
    }

    public function latest_revision()
    {
        return $this->hasMany(DocumentRevision::class)->latest("created_at")->first();//, 'document_revisions', 'document_id')->latest("created_at")->first();
    }

    public function attachable()
    {
        return $this->morphTo();
    }


    public function copyToDocumentRelation(DocumentRelationInterface $documentRelation)
    {
        $currentRevision = $this->latest_revision();

        $copy = new Document();
        $copy->title = $this->title;

//        $currentFullPath = ;
        $currentFullPathSplit = explode("/", $currentRevision->path );
        $currentFileName = end($currentFullPathSplit);
        $currentPath = substr($currentRevision->path, 0 , strlen($currentRevision->path) - strlen($currentFileName));
        $currentSplitFileName = explode(".", $currentFileName);
        $currentFileType = end($currentSplitFileName);
        $currentVersionSplitFileName = explode("_", $currentFileName);
        $currentFileNoVersion = substr($currentFileName, 0 , strlen($currentFileName) - strlen(end($currentVersionSplitFileName)) - 1);
        $relationClassName = explode("\\", get_class($documentRelation));
        $relationClassName = end($relationClassName);
        $newFileName = $currentFileNoVersion . "_1." . $currentFileType;
        $newPath = DocumentBaseRepository::BASE_PATH . $relationClassName . "_files/" . $relationClassName . "_" . $documentRelation->id . "/";
        $newPathWithoutBase = $relationClassName . "_files/" . $relationClassName . "_" . $documentRelation->id . "/";


        UploadController::copyFile($currentFileName, $newFileName, DocumentBaseRepository::BASE_PATH . $currentPath, $newPath);



//        $prettyFilenameAndVersion = substr($prettyFilename, 0, strlen($prettyFilename) - strlen($fileType) - 1) . "_" . $newDocumentRevision->version . "." . $fileType;


//        $copy->attachable()->save($documentRelation);

        $documentRelation->documents()->save($copy);

        $copy->save();

        $copyRevision = new DocumentRevision();
        $copyRevision->path = $newPathWithoutBase . $newFileName;
        $copyRevision->version = 1;
        $copyRevision->size = $currentRevision->size;
        $copyRevision->status = "created";
        $copyRevision->document_id = $copy->id;
        $copyRevision->save();

        return $copyRevision;
    }

}