<?php

namespace App\Http\Controllers;

use App\ClientToken;
use App\Traits\TokenTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ClientTokenController extends Controller {
    use TokenTrait;

    # Prüft, ob ein Token eines bestimmten Types vorhanden
    # und noch gültig ist
    public static function checkTokenValidity($type, $token) {
        # Token laden
        $tokenEntry = ClientToken::where("type", $type)
            ->where("token", self::hashToken($token))
            ->orderBy("timestamp", "Desc")
            ->first();

        # Token nicht gefunden
        if (!$tokenEntry) return false;

        # Gültigkeit prüfen
        $tokenTimestamp = \DateTime::createFromFormat("Y-m-d H:i:s", $tokenEntry->timestamp);
        $now = new \DateTime();

        $diff = abs($now->getTimestamp() - $tokenTimestamp->getTimestamp());

        if ($diff >= config('constants.client.tokenValidity.' . $type))
            return false;
        else return $tokenEntry;
    }


    public static function clearClientTokenTable() {
        Log::info("### Start Aufräumen ClientTokenTabelle / ClientTokenController::clearClientTokenTable");

        # Alle Token aus Datenbank holen
        $tokenList = ClientToken::all();

        $now = time();
        $i = 0;

        # Gültigkeit festlegen
        $maximumAge["register"] = config('constants.client.tokenValidity.register');
        $maximumAge["completeData"] = config('constants.client.tokenValidity.completeData');

        # Jedes Token prüfen
        foreach ($tokenList as $tokenItem) {
            # Alter des Tokens berechnen
            $tokenTimestamp = \DateTime::createFromFormat("Y-m-d H:i:s", $tokenItem->timestamp);

            $tokenAge = abs($now - $tokenTimestamp->getTimestamp());

            if ($tokenAge > $maximumAge[$tokenItem->type]) {
                # Token löschen wenn abgelaufen
                if ($tokenItem->delete())
                    $i++;
                else
                    Log::info("### Fehler beim Löschen von Eintrag");
            }
        }

        # Abschließen
        Log::info("### " . $i . " Token gelöscht");
        Log::info("### Ende Aufräumen ClientTokenTabelle / ClientTokenController::clearClientTokenTable");
    }


}
