<?php

namespace App\Http\Controllers;

use App\User;
use App\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\OrdersController;

class HomeController extends Controller {
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        $this->middleware('auth');
    }

    /**
     * Show outside login
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {

        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("seeOrdersList", $loggedUser))
            return view('home');

        # Allgemeine Parameter für Anzeige der Auftragsliste holen
        $parameters = OrdersController::getParametersForOrdersList($loggedUser);

        # Auf Startseite sollen nur Aufträge angezeigt werden, deren Verantwortlicher der eingeloggte Bearbeiter ist
        $preFilters = ["responsible" => $loggedUser->operator->id];
        $parameters["preFilters"] = $preFilters;
        $parameters["showOrdersList"] = true;

        return view('home')->with($parameters);

    }
}
