<?php

namespace App\Http\Controllers;


use App\User;
use App\Client;
use App\OrderAddresses;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use JsValidator;

class OrderAddressesController extends Controller {

    private $orderAddressValidationRules = [
        'address_name' => 'required|string|max:255',
        'address_firstname' => 'required|string|max:255',
        'address_company' => 'string|nullable|max:255',
        'address_street' => 'required|regex:/\b[A-Za-z\.\-\säÄöÖüÜß]+/|max:255',
        'address_house_number' => 'required|regex:/\b[0-9]{1,4}[a-zA-Z]{0,1}\b/',
        'address_address_addendum' => 'string|nullable|max:255',
        'address_zipcode' => 'required|regex:/\b[0-9]{4,6}\b/',
        'address_place' => 'required|regex:/\b[A-Za-z.\-\säÄöÖüÜß]+\b/|max:255',
        'address_country' => 'required|regex:/\b[A-Za-z\-\säÄöÖüÜß]+\b/|max:255',
        'address_telephone_number' => 'string|nullable|max:255',
        'address_note' => 'string|nullable|max:255',
        'address_email_final_customer' => 'nullable|email',
    ];


    public function edit($orderAddressId) {
        $loggedUser = User::find(Auth::user()->id);

        # Berechtigung prüfen
        if (!UserController::checkRight("editOrders", $loggedUser))
            return response()->json(['response' => 'error', 'message' => 'Keine Berechtigung.']);

        # Neue Adresse erstellen
        if ($orderAddressId == 0) {
            $orderAddress = new OrderAddresses();
        }
        # Adresse bearbeiten
        else {
            # Adresse finden
            $orderAddress = OrderAddresses::find($orderAddressId);
            if ($orderAddress == null) {
                return response()->json(['response' => 'error', 'message' => 'Adresse nicht gefunden.']);
            }
        }

        # Validierung
        $frontValidator = JsValidator::make($this->orderAddressValidationRules, [], [], "#editOrderAddress");

        $arguments = ["orderAddress" => $orderAddress,
            "validator" => $frontValidator];

        # View rendern
        $editorHTML = View::make('order_conf.order_addresses.edit')->with($arguments)->render();

        return response()->json(['response' => 'success', 'editorHTML' => $editorHTML]);
    }

    public function initAdresses()
    {
        // Alle Adressen in der Datenbank prüfen, ob hier Geokoordinaten hinterlegt sind
        $adressen = OrderAddresses::all();

        foreach ($adressen as $adresse) {
            if($adresse->latitude == null || $adresse->longitude == null)
            {

                $addressString = $adresse->street . " " . $adresse->house_number;
                $addressString.= ", " . $adresse->zipcode . " " . $adresse->place;

                $result = OrdersController::geocode($addressString);
                if($result !== false)
                {
                    // Geocoordinaten konnten korrekt bestimmt werden
                    $adresse->latitude = $result[0];
                    $adresse->longitude = $result[1];
                    $adresse->save();
                }

            }
        }

    }

}
