<?php

namespace App\Http\Controllers;

use App\OrderDocuments;

use App\Http\Controllers\UploadController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class OrderDocumentsController extends Controller {

    public static function getIconPath($mimetype) {

        $icon = false;

        # Prüfen, ob MIME-Typ Bild ist
        if (substr($mimetype, 0, 6) == "image/")
            $icon = "thumbnail_image.png";
        else {
            # Weitere Dateitypen
            switch ($mimetype) {
                case 'application/pdf':
                    $icon = "thumbnail_pdf.png";
                    break;

                // Microsoft Word
                case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
                case 'application/vnd.openxmlformats-officedocument.wordprocessingml.template':
                case 'application/msword':
                    $icon = "thumbnail_word.png";
                    break;

                // Microsoft Powerpoint
                case 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
                case 'application/vnd.openxmlformats-officedocument.presentationml.slide':
                case 'application/vnd.openxmlformats-officedocument.presentationml.slideshow':
                case 'application/vnd.ms-powerpoint':
                    $icon = "thumbnail_powerpoint.png";

                    break;

                // Microsoft Excel
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.template':
                case 'application/vnd.ms-excel':
                    $icon = "thumbnail_excel.png";

                    break;
                default:
                    $icon = "thumbnail_file.png";
            }
        }

        # Vollständige URL auslesen
        $url = Storage::disk("publicImages")->url("/fileIcons/" . $icon);

        return $url;
    }

    public static function getReadableMimetype($mimetype) {

        $type = false;

        # Prüfen, ob MIME-Typ Bild ist
        if (substr($mimetype, 0, 6) == "image/")
            $type = "Bild";
        else {
            # Weitere Dateitypen
            switch ($mimetype) {
                case 'application/pdf':
                    $type = "PDF";
                    break;

                // Microsoft Word
                case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
                case 'application/vnd.openxmlformats-officedocument.wordprocessingml.template':
                case 'application/msword':
                    $type = "Textdokument";
                    break;

                // Microsoft Powerpoint
                case 'application/vnd.openxmlformats-officedocument.presentationml.presentation':
                case 'application/vnd.openxmlformats-officedocument.presentationml.slide':
                case 'application/vnd.openxmlformats-officedocument.presentationml.slideshow':
                case 'application/vnd.ms-powerpoint':
                    $type = "Präsentation";

                    break;

                // Microsoft Excel
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
                case 'application/vnd.openxmlformats-officedocument.spreadsheetml.template':
                case 'application/vnd.ms-excel':
                    $type = "Tabellendokument";

                // Microsoft Outlook
                case 'application/x-msg':
                case 'application/CDFV2-unknown':
                    $type = "E-Mail";

                    break;
                default:
                    $type = "Datei";
            }
        }

        return $type;
    }

    public function downloadDocument($orderDocumentId) {
        # Dokument aus Datenbank holen
        $orderDocument = OrderDocuments::find($orderDocumentId);

        if ($orderDocument == null) echo "Dokument nicht gefunden.";

        return UploadController::downloadFile($orderDocument->path);
    }

    public function asyncLock() {

        // Benutzer bestimmen und mit zum Dokument sichern
        $userId = Auth::user()->id;

        $documentid = request()->get("documentid");
        $newLockState = request()->get("newLockState");

        $doc = OrderDocuments::find($documentid);
        $doc->locked = $newLockState;
        $doc->save();

        return response()->json(['response' => 'success']);
    }

}
