<?php

namespace App\Jobs;

use App\Mail\OrderMail;
use App\OrderMailLog;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class SendOrderMailJob implements ShouldQueue {
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $to;
    protected $orderMail;
    protected $operatorId;
    protected $orderId;
    protected $orderMailLogId;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($to, OrderMail $orderMail, $operatorId, $orderId, $orderMailLogId) {
        $this->to = $to;
        $this->orderMail = $orderMail;
        $this->operatorId = $operatorId;
        $this->orderId = $orderId;
        $this->orderMailLogId = $orderMailLogId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle() {

        # Eintrag für Auftragsmaillog schreiben
        $logEntry = OrderMailLog::find($this->orderMailLogId);

        # Logeintrag schreiben, wenn nicht gefunden
        if ($logEntry == null) {
            $logEntry->order_id = $this->orderId;
            $logEntry->operator_id = $this->operatorId;
            $logEntry->to = $this->to;
            $logEntry->subject = $this->orderMail->subject;
            $logEntry->text = $this->orderMail->content;
            $logEntry->sent = false;

            $logEntry->save();
        }

        # Versuchen, Mail zu senden
        try {
            Mail::to($this->to)->send($this->orderMail);

        } catch (\Exception $e) {
            $logEntry->error = true;
            $logEntry->save();
            $this->failed($e);
        }

        $logEntry->sent = true;
        $logEntry->save();
    }


    /**
     * The job failed to process.
     *
     * @return void
     */
    public function failed($exception) {
        Log::error($exception->getMessage());
        Log::error($exception->getCode());
        Log::error($exception->getFile());
        Log::error($exception->getLine());
        throw new \Exception("Fehler beim Versenden der Auftragsmail.");
    }
}
