<?php

namespace App\Jobs;

use App\Mail\SetNewRegisterPassword;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

use Illuminate\Support\Facades\Log;
use Exception;
use Illuminate\Support\Facades\Mail;

class SendSetNewRegisterPasswordJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $to;
    public $setNewRegisterPassword;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($to, SetNewRegisterPassword $setNewRegisterPassword)
    {
        $this->to = $to;
        $this->setNewRegisterPassword = $setNewRegisterPassword;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        Mail::to($this->to)->send($this->setNewRegisterPassword);
    }

    /**
     * The job failed to process.
     *
     * @param  Exception  $exception
     * @return void
     */
    public function failed(Exception $exception)
    {
        Log::error($exception->getMessage());
    }
}
