<?php
# Bildet eine Dropzone ab und dient der Generierung von HTML- und JavaScript-Code

namespace App\Library;

use Illuminate\Support\Facades\View;

class Dropzone {
    public $relatedForm;
    public $formID;
    private $route;
    private $showExistingFile = false;
    private $existingFile;
    private $dropAnimation;
    private $animationIcon;
    private $dropzoneOptions;

    public function __construct($dropzoneOptions,
                                $relatedForm,
                                $formID = "anotherDropzone",
                                $route = "default",
                                $showExistingFile = false, $existingFile = "",
                                $dropAnimation = true, $animationIcon = "fas fa-images") {

        $this->relatedForm = $relatedForm;
        $this->formID = $formID;
        $this->route = $route;

        if ($route == "default") $this->route = "dropzone.uploadTemporaryFile";
        else $this->route = $route;

        $this->showExistingFile = $showExistingFile;

        if ($this->showExistingFile == true) $this->existingFile = $existingFile;

        $this->dropAnimation = $dropAnimation;

        if ($this->dropAnimation == true) $this->animationIcon = $animationIcon;


        # Dropzone-Optionen festlegen, ggf. Standard-Einstellungen hinzufügen
        if (is_array($dropzoneOptions)) {
            $this->dropzoneOptions = self::mergeOptions($this->getDefaultOptions(),
                $dropzoneOptions);
        }
    }

    # Standard-Optionen für die Dropzone; diese Einstellungen sind für eine sinnvolle Verwendung
    # obligatorisch!
    private function getDefaultOptions() {

        $defaultOptions = array();

        # Standardeinstellungen
        $defaultOptions["paramName"] = '"uploadFile"';
        $defaultOptions["previewsContainer"] = '"#' . $this->formID . ' .showFilePreview"';

        $defaultOptions["clickable"] = '["#' . $this->formID . ' .showFilePreview",
             "#' . $this->formID . ' .dropUpload"';

        if ($this->showExistingFile == true)
            $defaultOptions["clickable"] .= ', "#' . $this->formID . ' .existingFile .img"';
        else
            $defaultOptions["clickable"] .= ', "#' . $this->formID . ' .existingFile"';

        $defaultOptions["clickable"] .= ']';

        $defaultOptions["maxFiles"] = 1;
        $defaultOptions["acceptedFiles"] = '"image/jpg,image/jpeg,image/png,image/gif"';
        $defaultOptions["maxFilesize"] = 1;
        $defaultOptions["thumbnailWidth"] = 195;
        $defaultOptions["thumbnailHeight"] = 195;

        # Standardübersetzungstexte
        $defaultOptions["dictFileTooBig"] = '"Die Datei ist zu groß. Erlaubte Dateigröße: {{maxFilesize}} MB."';
        $defaultOptions["dictMaxFilesExceeded"] = '"Es kann nur ein Bild hochgeladen werden."';
        $defaultOptions["dictInvalidFileType"] = '"Dieser Dateityp ist nicht erlaubt."';

        return $defaultOptions;
    }

    # Dropzone-Optionen kombinieren aus Standard- und übermittelten Werten
    public static function mergeOptions($defaultOptions, $userOptions) {
        if (!is_array($userOptions)) return $defaultOptions;

        $mergedOptions = array();

        foreach ($defaultOptions as $defaultOptionKey => $defaultOptionValue) {
            # Prüfen, ob Option von User übermittelt wurde
            # Wenn ja, hinzufügen
            if (array_key_exists($defaultOptionKey, $userOptions)) {
                $mergedOptions[$defaultOptionKey] = $userOptions[$defaultOptionKey];
            } # Wenn nein, default Option hinzufügen
            else {
                $mergedOptions[$defaultOptionKey] = $defaultOptions[$defaultOptionKey];
            }
        }
        return $mergedOptions;
    }

    public static function convertToJSArray($arrayToConvert) {
        if (!is_array($arrayToConvert)) return false;

        $jsArray = "";

        foreach ($arrayToConvert as $key => $value) {

            $jsArray = $jsArray . $key . ": ";

            if (is_array($value)) {
                $jsArray = $jsArray . "[";
                foreach ($value as $item) {
                    $jsArray = $jsArray . $item . ",";
                }
                $jsArray = $jsArray . "]";
            } else $jsArray = $jsArray . $value;

            $jsArray = $jsArray . ", ";
        }

        return $jsArray;
    }

    public function getDropzoneForm($animationIcon = "standard") {
        $parameters["formID"] = $this->formID;
        $parameters["route"] = $this->route;
        $parameters["showExistingFile"] = $this->showExistingFile;
        $parameters["existingFile"] = $this->existingFile;
        $parameters["dropAnimation"] = $this->dropAnimation;
        $parameters["animationIcon"] = $this->animationIcon;
        $parameters["inputName"] = $this->dropzoneOptions["paramName"];

        $htmlForm = View::make('dropzone.htmlForm', $parameters);

        return $htmlForm->render();
    }

    public function getDropzoneJSCode() {
        # Parameter setzen
        $parameters = array();
        $parameters["relatedForm"] = $this->relatedForm;
        $parameters["formID"] = $this->formID;
        $parameters["dropAnimation"] = $this->dropAnimation;
        $parameters["showExistingFile"] = $this->showExistingFile;

        # Einstellungen für die Dropzone in JS-Code umwandeln
        $parameters["options"] = $this->convertToJSArray($this->dropzoneOptions);

        $customJS = View::make('dropzone.customJSCode', $parameters);
        $jsCode = $customJS->render();

        return $jsCode;
    }
}