<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class OrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $content;
    public $orderDocuments;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject, $text, $orderDocuments = [])
    {
        $this->subject = $subject;
        $this->content = $text;
        $this->orderDocuments = $orderDocuments;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $email = $this->subject($this->subject)
            ->view('mail.blankMail');

        foreach ($this->orderDocuments as $orderDocument) {
            $email->attach($orderDocument);
        }

        return $email;
    }
}
