<?php


namespace App;

use App\Repositories\Interfaces\DocumentRelationInterface;
use Illuminate\Database\Eloquent\Model;

class ProjectType extends Model implements DocumentRelationInterface
{
    # Projekt
    public function projects() {
        return $this->belongsToMany(Project::class, 'projects', 'project_type_id');
    }

    # DocumentTemplates
    public function documentTemplates() {
        return $this->hasMany(DocumentTemplate::class, 'project_type_id');
    }

//    public function document_templates() {
//        return $this->belongsToMany(DocumentTemplate::class, 'project_type_document_templates', 'project_type_id')->withPivot('id');
//    }

    public function documents()
    {
        return $this->morphMany(Document::class, 'attachable');
    }


}