<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\Client;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Use for Versions under MySQL 5.7.7 or MariaDB 10.2.2
        Schema::defaultStringLength(191);

        view()->composer('*', function($view) {
            if(Auth::check()) {
                # Userobjekt für den eingeloggten User erstellen
                $id = Auth::user()->id;
                $user = User::find($id);

                # Zugehörigen Mandanten des eingeloggten Users laden
                $client = $user->client;

                $view->with(['user' => $user, 'client' => $client]);
            }
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
