<?php


namespace App\Repositories;


use App\Article;
use App\Http\Controllers\UserController;
use App\Repositories\Interfaces\DocumentInterface;
use App\Document;
use App\DocumentRevision;
use App\ProjectType;
use App\User;

class ProjectTypeDocumentRepository extends DocumentBaseRepository
{
    public function __construct(ProjectType $projectType = null, $loadResources = false){
        if($projectType != null) $this->setProjectType($projectType);
        if($projectType != null && $loadResources) $this->loadResources();
    }


    public function resolveDocuments(User $user, $request)
    {
        $projectTypeId = $request->get("projectTypeToEdit");
        $projectTypeTitle = $request->get("title");

        # Berechtigung prüfen
        if (!UserController::checkRight("editProjectTypes", $user))
            return redirect()->route('index');

        # Auftragstyp lesen
        $projectType = ProjectType::find($projectTypeId);
        if ($projectType == null) {
            return redirect()->back()->withErrors("Projekttyp nicht gefunden.");
        }

        $projectType->title = $projectTypeTitle;
        $this->setProjectType($projectType);
        $this->setDocumentRelationObject($projectType);

        $existingDocumentFieldsJson = json_decode($request->get('documentFileFields'));
        $existingDocumentFields = $existingDocumentFieldsJson->fields;


        parent::resolveDocuments($user, $request);

        foreach($existingDocumentFields as $existingDocumentField)
        {
            $versionDocumentRepository = new DocumentBaseRepository();
            $versionDocumentRepository->dropzoneName = $existingDocumentField;
            $versionDocumentRepository->resolveDocuments($user, $request);
        }
    }


    public function setProjectType($projectType)
    {
        $this->classFolderName = "projecttype";
        $this->isTemplate = true;
        $this->folderId = $projectType->id;
        $this->projectType = $projectType;
    }



}