<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Storage;
use App\Notifications\ResetPassword;

class User extends Authenticatable {
    use Notifiable;
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'firstname', 'email', 'password', 'newEmail', 'deletedBy'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function getNewMail() {
        return $this->newEmail;
    }

    public function getImage() {
        if ($this->image != NULL)
            return Storage::disk("uploads")->url($this->image);
        else
            return "/images/dummy.svg";
    }

    public function getName() {
        return $this->name . " " . $this->firstname;
    }

    public function client() {
        return $this->belongsTo(Client::class);
    }

    public function right() {
        return $this->belongsToMany(Rights::class);
    }

    public function operator() {
        return $this->hasOne(Operator::class);
    }


    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPassword($token));
    }
}
