<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientsTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        # Nur ID, Name, E-Mail-Adresse für den ersten Kontakt und das Aktiviert-Feld sind Pflichtfelder, da diese für
        # das erste Anlegen benötigt werden. Die weiteren Daten werden im Nachhinein durch den ersten
        # Mandantenadministrator nachgepflegt.
        # Das Feld 'firstContactMail' wird nur für die initiale Registrierung benötigt, um eine Kontaktmöglichkeit zum
        # Mandanten zu haben, sollte die Registrierung der ersten Mandantenadministrators fehlschlagen. Nach der
        # Registrierung und Ergänzung der Stammdaten wird das Feld geleert.
        Schema::create('clients', function (Blueprint $table) {
            $table->increments('id');

            $table->string('name')->unique();
            $table->string('street')->default("");
            $table->string('houseNumber')->default("");
            $table->string('zipcode')->default("");
            $table->string('place')->default("");
            $table->string('country')->default("");
            $table->string('vatNo')->default("");

            $table->string('logo')->nullable()->default(NULL);

            $table->string('firstContactMail');
            $table->boolean('activated')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('number_ranges');
        Schema::dropIfExists('clients');
    }
}
