<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string('name');
            $table->string('firstname');
            $table->string('email')->unique();
            $table->string('newEmail')->nullable()->default(NULL);

            $table->string('image')->nullable()->default(NULL);

            $table->boolean('active')->default(true);
            $table->string('deactivated')->nullable()->default(NULL);
            $table->string('password');
            $table->rememberToken();

            $table->integer('client_id')->unsigned()->nullable()->default(NULL);
            $table->integer('operator_id')->unsigned()->nullable()->default(NULL);

            $table->timestamps();
            $table->integer('deleted_by')->unsigned()->nullable();
            $table->softDeletes();

            $table->foreign('client_id')->references('id')->on('clients');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('users');
    }
}
