<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRightsTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('rights', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('rights_group_id')->unsigned();
            $table->string('name')->unique();
            $table->string('label')->unique();
            $table->string('description', 250)->default("");
            $table->timestamps();
            $table->foreign('rights_group_id')->references('id')->on('rights_groups');
        });

        Schema::create('rights_user', function (Blueprint $table) {
            $table->integer('rights_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('rights_id')->references('id')->on('rights')->onDelete('cascade');
            $table->primary(['rights_id', 'user_id']);
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('rights_user');
        Schema::dropIfExists('rights');
    }
}
