<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCustomersTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('customers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('customer_number');
            $table->integer('client_id')->unsigned();

            # toDo: Spalten mit Default versehen, da Daten von PK nicht vollständig
            $table->string('company');
            $table->string('title')->nullable()->default(null);
            $table->string('name')->nullable()->default('');
            $table->string('firstname')->nullable()->default('');
            $table->string('street')->nullable()->default('');
            $table->string('house_number')->nullable()->default('');
            $table->string('zipcode')->nullable()->default('');
            $table->string('place')->nullable()->default('');
            $table->string('country')->nullable()->default('');
            $table->string('telephone_number')->nullable()->default('');
            $table->string('fax_number')->nullable()->default('');
            $table->string('email')->nullable()->default('');
            $table->integer('pricegroup')->default(1);

            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('customers');
    }
}
