<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrdersTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_number');

            $table->integer('client_id')->unsigned();
            $table->integer('customer_id')->unsigned();
            $table->integer('order_type_id')->unsigned();
            $table->integer('order_status_id')->unsigned();
            $table->integer('order_payment_status_id')->unsigned();
            $table->integer('apartment_units')->default(1);
            $table->integer('responsible_operator_id')->nullable()->default(NULL);
            $table->text('description')->nullable();

            $table->timestamp('created')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('end_date')->default(DB::raw('CURRENT_TIMESTAMP'));

            $table->timestamps();

            $table->softDeletes();

            $table->foreign('client_id')->references('id')->on('clients');
            $table->foreign('customer_id')->references('id')->on('customers');
            $table->foreign('order_type_id')->references('id')->on('order_types');
            $table->foreign('order_status_id')->references('id')->on('order_statuses');
            $table->foreign('order_payment_status_id')->references('id')->on('order_payment_statuses');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('order_operators', function (Blueprint $table) {
            $table->dropForeign('order_operators_order_id_foreign');
        });
        Schema::dropIfExists('order_operators');
        Schema::dropIfExists('orders');
    }
}
