<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderTagsTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('order_tags', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('client_id')->unsigned();
            $table->string('label');
            $table->integer('order_types_id')->unsigned()->nullable()->default();

            $table->timestamps();

            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
            $table->foreign('order_types_id')->references('id')->on('order_types');
        });

        # Relation Auftrag - Auftragskennzeichen Wert (n:m)
        Schema::create('order_order_tag', function (Blueprint $table) {
            $table->integer('orders_id')->unsigned();
            $table->integer('order_tags_id')->unsigned();
            $table->string('tag_value')->nullable()->default(NULL);

            $table->primary(['orders_id', 'order_tags_id']);
            $table->foreign('orders_id')->references('id')->on('orders')->onDelete('cascade');
            $table->foreign('order_tags_id')->references('id')->on('order_tags');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('order_order_tag');
        Schema::dropIfExists('order_tags');
    }
}
