<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderAddressesTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('order_addresses', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('order_id')->unsigned();

            $table->string('name');
            $table->string('firstname');
            $table->string('company')->default('');

            $table->string('street');
            $table->string('house_number');
            $table->string('address_addendum');
            $table->string('zipcode');
            $table->string('place');
            $table->string('country');
            $table->string('telephone_number');
            $table->string('note')->default('');
            $table->string('email_final_customer')->default('');

            $table->timestamps();

            $table->foreign('order_id')->references('id')->on('orders');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('order_addresses');
    }
}
