<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class OrderAppointmentOperator extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        # Relation Auftrag - Auftragskennzeichen Wert (n:m)
        Schema::create('order_appointment_operator', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('orders_id')->unsigned();
            $table->integer('operator_id')->unsigned();
            $table->timestamp('appointment_from')->nullable()->default(NULL);
            $table->timestamp('appointment_to')->nullable()->default(NULL);

            $table->foreign('orders_id')->references('id')->on('orders');
            $table->foreign('operator_id')->references('id')->on('operators');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('order_appointment_operator');
    }
}
