<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class OperatorCalendarTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        # Relation Auftrag - Auftragskennzeichen Wert (n:m)
        Schema::create('operator_calendar', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('operator_id')->unsigned();
            $table->date('datescheduled')->nullable()->default(NULL);
            $table->integer('operator_calendar_status_id')->unsigned();

            $table->foreign('operator_id')->references('id')->on('operators');
            $table->foreign('operator_calendar_status_id')->references('id')->on('operator_calendar_statuses');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('operator_calendar');
    }
}
