<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateZipCoordinatesTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('zip_coordinates', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('loc_id')->unsigned();
            $table->string('zip', 10);
            $table->string('location_name', 255);

            $table->double('lat');
            $table->double('lon');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('zip_coordinates');
    }
}
