<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('client_id')->unsigned();

            $table->string('product_number', 50);
            $table->string('name', 255);

            // Verschiedene Preisgruppen (statisch hinterlegt)
            $table->double('price_1', 8, 2);
            $table->double('price_2', 8, 2);
            $table->double('price_3', 8, 2);
            $table->double('price_4', 8, 2);

            $table->timestamps();
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
