<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderInvoiceTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('order_invoice', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->unsigned();

            // Rechnungsnummer aus Nummernkreis
            $table->integer('invoice_number')->unsigned();

            // Wichtige Felder unveränderbar direkt zum Auftragskopf schreiben:
            // kundennummer, datum, firmenname, straße, hausnummer, plz, ort, land
            $table->integer('customer_id')->unsigned();
            $table->date('date_of_issue')->nullable()->default(NULL);
            $table->string('company');
            $table->string('street')->default('');
            $table->string('house_number');
            $table->string('zipcode');
            $table->string('place');
            $table->string('country');

            // Gesamtwert zur Prüfung / Kurzdarstellung
            // $table->double('total_price', 8, 2);

            $table->timestamps();
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('order_invoice');
    }
}
