<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderInvoicePositionsTable extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('order_invoice_positions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_invoice_id')->unsigned();

            $table->integer('products_id')->unsigned();
            $table->string('product_number', 50);
            $table->string('name', 255);
            $table->double('quantity', 8, 2);
            $table->double('price', 8, 2);

            $table->timestamps();
            $table->foreign('order_invoice_id')->references('id')->on('order_invoice')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('order_invoice_positions');
    }
}
