<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFixedVariablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fixed_variables', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('variable_id')->unsigned();
            $table->foreign('variable_id')->references('id')->on('variables')->onDelete('cascade');
            $table->text('ref_type');
            $table->text('ref_attr');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fixed_variables');
    }
}
