<?php

use Illuminate\Database\Seeder;
use Faker\Factory as Faker;
use Carbon\Carbon;
use App\Client;


class OrdersTableSeeder extends Seeder {

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run() {
        $client = Client::find(1);

        \DB::table('orders')->delete();

        return;
        $faker = Faker::create("de_DE");

        foreach (range(1, 100) as $index) {

            # Endtermin bestimmen
            $rand = $faker->dateTimeThisYear();

            $now = Carbon::createFromFormat("Y-m-d H:i:s", $rand->format("Y-m-d H:i:s"));
            $now->setTime(0, 0, 0);

            $nowTimestamp = $now->toDateTimeString();

            $then = $now->addDays(28);
            if ($then->isWeekend())
                $then->nextWeekDay();

            $then->setTime(0, 0, 0);

            $responsibleOperator = $faker->randomElement([1,2,17,18,18,20]);
            $responsibleOperator2 = $faker->randomElement([1,2,17,18,18,20]);
            if ($index <= 3) $responsibleOperator = 2;

            DB::table('orders')->insert([
                'id' => $index,
                'order_number' => $client->numberRangeOrders->getNextNumber(),
                'apartment_units' => $faker->numberBetween(1, 50),
                'client_id' => 1,
                'created' => $nowTimestamp,
                'end_date' => $then->toDateTimeString(),
                'customer_id' => $faker->numberBetween(1, 10),
                'description' => $faker->text(200),
                'order_payment_status_id' => $faker->numberBetween(1, 5),
                'order_status_id' => $faker->numberBetween(1, 6),
                'order_type_id' => $faker->numberBetween(1, 9)
            ]);


            if ($responsibleOperator > 0) {
                # Verantwortlichen hinzufügen
                DB::table('order_operators')->insert([
                    'order_id' => $index,
                    'operator_id' => $responsibleOperator,
                ]);

                if ($responsibleOperator2 <= 5) {
                    DB::table('order_operators')->insert([
                        'order_id' => $index,
                        'operator_id' => $responsibleOperator2,
                    ]);


                    // Wiedervorlage für Verantwortlichen hinzufügen
                    DB::table('order_follow_ups')->insert([
                        'order_id' => $index,
                        'operator_id' => $responsibleOperator2,
                        'note' => $faker->randomElement(["", $faker->text(20)]),
                        'nextUp' => $faker->dateTimeBetween('now', '+10 days'),
                    ]);
                }


                // Wiedervorlage für Verantwortlichen hinzufügen
                DB::table('order_follow_ups')->insert([
                    'order_id' => $index,
                    'operator_id' => $responsibleOperator,
                    'note' => $faker->randomElement(["", $faker->text(20)]),
                    'nextUp' => $faker->dateTimeBetween('now', '+10 days'),
                ]);
            }

            // Wenn Verantwortlicher = Jürgen, dann zwei Termine hinzufügen (zu Präsentationszwecken)
            if ($responsibleOperator == 2 && $index <= 3) {
                DB::table('order_appointment_operator')->insert([
                    'orders_id' => $index,
                    'operator_id' => $responsibleOperator,
                    'appointment_from' => $faker->dateTimeBetween('+1 days', '+10 days')
                ]);
            }
        }

    }
}