<?php

use Illuminate\Database\Seeder;

class ZipCoordinatesSeeder extends Seeder {
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {

      // Hinweis: Importdatei muss UTF-8 Kodierung aufweisen
      $file = str_replace("\\", "/", base_path('database/files/zip_coordinates.csv'));

      // Bei Headerzeilen: IGNORE 1 LINES
      $query = "LOAD DATA INFILE '" . $file . "'
          INTO TABLE zip_coordinates
          FIELDS TERMINATED BY ';' OPTIONALLY ENCLOSED BY '\"'
          LINES TERMINATED BY '\n'
          (loc_id,
          zip,
          location_name,
          lat,
          lon)
          ";

      DB::connection()->getpdo()->exec($query);
    }
}
