function showModalBox(_title, _body) {
    if ($("#modalBox")
        .length > 0) {
        $('#modalBox .modal-title')
            .html(_title);
        $('#modalBox .modal-body')
            .html(_body);
        $('#modalBox')
            .modal();
    }
}

jQuery(document).on('click', '#modalBox button', function () {
    if (jQuery("#modalBox").data("reload") == "true") {
        location.reload();
    }
});


function showOverlayAlert(message) {
    let allMessages = [];

    if (typeof message == "object") {
        // Für Fehlermeldungen aus der Valdierung von JsValidator (Kommen als Objekt mit verschachtelten Arrays, daher
        // das umständliche Auslesen.)
        Object.entries(message).forEach(function (element) {

            if (Array.isArray(element)) {
                element.forEach(function (item) {

                    if (Array.isArray(item)) {
                        item.forEach(function (content) {
                            allMessages.push(content);
                        });
                    }
                });

            }
        });
    }

    else if (Array.isArray(message)) {
        message.forEach(function (content) {
            allMessages.push(content);
        });
    }

    else allMessages.push(message);


    // Liste zusammensetzen
    let messageList = "<ul><li>";
    messageList = messageList + allMessages.join("</li><li>") + "</li></ul>";

    messageToDisplay = messageList;

    // Container anzeigen und Nachricht(en) hinzufügen
    jQuery("#editorContent .alertContainer .errorMessage").html(messageToDisplay);
    jQuery("#editorContent .alertContainer").show();
}


function guid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }

    return s4() + '-' + s4();
}


// Ajax-Funktion
function fireAjax(url, data, successFunction, errorFunction) {
    userID = this.id;

    // Ajax-Request für das Nachladen des Overlay-Forms vorbereiten
    var token = jQuery('meta[name="csrf-token"]').attr('content');
    jQuery.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': token
        }
    });

    // Token zu Daten hinzufügen
    data['_token'] = token;

    // Ajax bereithalten
    jQuery.ajax({
        method: 'POST',
        url: url,
        data: data,
        success: successFunction,
        error: errorFunction
    });
}

function callFunctionByString(callbackString, parameters) {
    window[callbackString](parameters);
}

function formatUNIXTimestampToDate(timestamp) {
    var a = new Date(timestamp * 1000);
    var year = a.getFullYear();
    var month = a.getMonth() + 1;
    var date = a.getDate();

    // leading zeros
    month = month.toString();
    if (month.length === 1) {
        month = "0" + month;
    }
    date = date.toString();
    if (date.length === 1) {
        date = "0" + date;
    }

    var time = date + '.' + month + '.' + year;

    return time;
}

function convertTimestampToHTMLDateString(timestamp) {
    return timestamp.substring(0, 10);
}

function formatDateStringToReadableDate(dateString) {
    if (dateString == "") return "";
    let y = dateString.substring(0, 4);
    let m = dateString.substring(5, 7);
    let d = dateString.substring(8, 10);

    return (d + "." + m + "." + y);
}


jQuery(function () {
    // adjust height of alert icon
    jQuery(".alert").each(function (index) {
        var height = jQuery(this).height();
        icon = (jQuery(this).find(".alertIcon"));
        icon.height(height);
    });

    // Anzahl von Benachrichtigungen anzeigen
    jQuery("#followUpsBell").hover(function () {
            jQuery("#followUpsTodayCnt").fadeIn();
        },
        function () {
            jQuery("#followUpsTodayCnt").fadeOut();
        });
});

// Suchfunktion für Listen
jQuery(document).on("keyup", "input#searchFor", function () {
    let noSearchResultsContainer = jQuery(this).data("shownosearchresults");

    jQuery("div[data-nosearchresults=" + noSearchResultsContainer + "]").removeClass("noSearchResultsShow");

    searchValues = [];
    searchString = this.value.toLowerCase();

    searchValues = searchString.split(" ");
    let items = [];
    let itemsHide = [];

    jQuery(".searchItem").each(function () {
        item = this;

        var name = jQuery(this).data("search-for").toLowerCase();

        var hide = false;

        searchValues.forEach(function (val) {
            if (val == "") {
                return;
            }

            if (!name.includes(val)) {
                hide = true;
            }
        });

        if (hide)
            itemsHide.push(item);
        else
            items.push(item);

    });

    items.forEach(function (value) {
        jQuery(value).show();
    });

    itemsHide.forEach(function (value) {
        jQuery(value).hide();
    });

    if (items.length === 0) {
        jQuery("div[data-nosearchresults=" + noSearchResultsContainer + "]").addClass("noSearchResultsShow");
    }

});

// Ausklappbares Input
jQuery(document).on("focus", "input.slide-input", function () {
    jQuery(this).addClass("slideOut");
});

// Input einklappen
jQuery(document).on("focusout", "input.slide-input.search", function () {
    // Wenn noch Text im Suchfenster steht, offen lassen
    if (jQuery(this).val() != "") return;

    jQuery(this).val("");
    jQuery(this).removeClass("slideOut");

    jQuery("#noSearchResults").removeClass("noSearchResultsShow");
    jQuery(".searchItem").show();
});


// Editor-Fenster schließen bei Klick auf X
jQuery(document).on('click', '#closeListEditor', function () {
    hideLoadingSpinner();
});

jQuery(document).on('click', '#closeListEditorButton', function () {
    jQuery("#closeListEditor").trigger("click");
});

// Editor-Fenster schließen beim Drücken der ESC-Taste
jQuery(document).on('keydown', 'body', function (event) {
    if (event.which == "27") {
        jQuery("#closeListEditor").trigger("click");
    }
});

function showLoadingSpinner() {
    jQuery("#listOverlay").fadeIn();
    jQuery("#listEditor").hide();
    jQuery("#loadingSpinner").show();
}

function hideLoadingSpinner() {
    jQuery("#listOverlay").fadeOut('400', function () {
        jQuery("#listEditor").removeClass();
    });
}

function showOverlayLoadingSpinner() {
    jQuery("#overlayOverlay").fadeIn();
    jQuery("#overlayLoadingSpinner").show();
}

function hideOverlayLoadingSpinner() {
    jQuery("#overlayOverlay").fadeOut();
    jQuery("#overlayLoadingSpinner").hide();
}

jQuery(document)
    .on("click", ".multiselect .selectBox", function () {

        var parentContainer = jQuery(this).parents(".multiselect");
        var openStatus = jQuery(parentContainer).data("show-checkboxes");
        var checkboxes = jQuery(parentContainer).find(".checkboxes");

        if (openStatus == "0") {
            jQuery(parentContainer).data("show-checkboxes", "1");
            jQuery(checkboxes).show();
        }
        else {
            jQuery(parentContainer).data("show-checkboxes", "0");
            jQuery(checkboxes).hide();
        }
    });

jQuery(document)
    .on("blur", ".multiselect .checkboxes", function () {
        var parentContainer = jQuery(this).parents(".multiselect");
        var openStatus = jQuery(parentContainer).data("show-checkboxes");
        var checkboxes = jQuery(parentContainer).find(".checkboxes");
        if (openStatus == "1") {
            jQuery(parentContainer).data("show-checkboxes", "0");
            jQuery(checkboxes).hide();
        }
    });


jQuery(document).ready(function () {
    if (jQuery(".multiSelectorObject").length) {
        jQuery(".multiSelectorObject").multiselect();
    }
// Mehr zeigen - Buttontexte anpassen
    jQuery("button.showMoreEntries").click(function () {

        let newText = "";
        let newStatus = "";

        // Aktuellen Status feststellen
        let status = jQuery(this).data("status");
        let id = jQuery(this).attr("id");

        // Neuen Text festlegen
        if (status === "more") {
            newText = "Mehr anzeigen";
            newStatus = "less";
        }
        else {
            newText = "Weniger anzeigen";
            newStatus = "more";
        }

        // Neuen Buttontext setzen
        jQuery("button#" + id + " span.buttonText").html(newText);
        // Neuen Status setzen
        jQuery(this).data("status", newStatus);

    });
});

jQuery( window ).resize(function() {

    if(jQuery(".specialwidth").length)
    {
        specialResize();
    }
});


function specialResize()
{
    jQuery(".innertablescrollframe>.table .tr:first-child .td").each(function( index )
    {
        $dayWidth = $( this ).width();
        // Headerelement Breite setzen
        jQuery(".specialwidth:nth-child("+(index+1)+")").width($dayWidth);
    });
}

