/* Funktionen für die Filterung, Sortierung und Auflistung von Aufträgen */
/* Nicht allgemein, sondern Bezug auf bestimmte ID-DIVs etc.!! */


/* Vollständiges Einblenden der Filter */
/* Beim Klick auf einen Filter-Shortcut klappt dieser aus und zeigt eine Möglichkeit der Werteeingabe, wie z.B. ein
 * Textfeld oder ein Dropdown.
 */
jQuery(document).on('click', 'div.filter', function () {

    // Filterkennung auslesen
    let filterType = jQuery(this).data("filtertype");
    let inputType = jQuery(this).data("inputtype");

    // Großen Filter anzeigen
    jQuery(".filter-extended[data-filtertype=" + filterType + "]").addClass("filter-extended-show");

    // Focus setzen
    setFocus(filterType, inputType);

    // Filter ausblenden
    jQuery(".filter[data-filtertype=" + filterType + "]").hide();

    // Suche-Button einblenden
    jQuery("button#startSearch").fadeIn();
});

/* Filter wieder zurücksetzen */
jQuery(document).on('click', 'div.filterClose', function () {
    let filterType = jQuery(this).data("filtertype");
    removeFilter(filterType);
});

jQuery(document).on('click', 'div.filterCloseSmall', function () {
    let filterType = jQuery(this).data("filtertype");
    removeFilter(filterType);
});

function removeFilter(filterType) {


    let filter = jQuery(".filter-extended[data-filtertype=" + filterType + "]");
    let inputType = jQuery(filter).data("inputtype");

    // Großen Filter ausblenden
    jQuery(filter).removeClass("filter-extended-show");

    // Filter einblenden
    jQuery(".filter[data-filtertype=" + filterType + "]").show();


    //
    // Filterwerte leeren
    //

    // Input-Feld oder Checkbox leeren
    if (inputType == "text" || inputType == "textSearch" || inputType == "multiText") {
        jQuery(filter).find("input").each(function () {
            jQuery(this).val("");
            jQuery(this).prop("checked", "");
        });
    }

    // Dropdowns, also Status, Typ
    if (inputType == "dropdown") {
        jQuery(".filter-extended[data-filtertype=" + filterType + "]  > .filterValue > span > select.multiSelectorObject")
            .multiselect("deselectAll", false)
            .multiselect("updateButtonText");
    }
    // Kennzeichen
    if (inputType == "tag") {
        // Checkbox Kennzeichen
        jQuery(".filter-extended[data-filtertype=" + filterType + "]  > .filterValue > span > select.multiSelectorObject")
            .multiselect("deselectAll", false)
            .multiselect("updateButtonText");

        // Wert Kennzeichen
        jQuery(filter).find("input").each(function () {
            jQuery(this).val("");
        });
    }


    // Ggf. Suche-Button ausblenden
    if (jQuery(".filter-extended-show").length < 1) {
        jQuery("button#startSearch").fadeOut();
    }

    // Suche neu triggern
    startSearch(entriesPerPage, 0, canCreateOrders, canEditOrders, canDeleteOrders, 0, listType, hideSensibleOrderData);
}

/* Klick auf "Ohne" bei Verantwortlichem: Input disablen bzw. enablen */
jQuery(document).on('click', 'input#noResponsible', function () {

    // Zustand bestimmen
    let noResponsibleActive = jQuery("input[name=noResponsible]").prop("checked");

    if (noResponsibleActive) {
        jQuery("input[name=responsible]").val("");
        jQuery("input[name=responsible]").prop("disabled", "disabled");
    }
    else {
        jQuery("input[name=responsible]").prop("disabled", "");
    }
});

/* Suchparameter auslesen */

/* Aus den Filter-Divs .filter-extended-show (übergeordnet .filterBarExtended) werden die Data-Attribute
 * inputtype und filtertype gelesen. Abhängig vom Inputtyp (z.B. Text oder Dropdown) werden die Wert gezogen und in einem
 * Array zurückgegeben.  */
function getSearchParameters(listType) {

    let searchData = {"tags": {}};

    jQuery(".filterBarExtended").find(".filter-extended-show").each(function () {

        let filter = jQuery(this);
        let inputType = jQuery(this).data("inputtype");
        let filterType = jQuery(this).data("filtertype");

        // Einfache Inputfelder, also z.B. Auftragsnr. etc.
        if (inputType == "text") {
            searchData[filterType] = jQuery(this).find("input[name=" + filterType + "]").val();
        }
        // Aus Suchfeldern, z.B. Auftraggeber
        if (inputType == "textSearch") {
            // ggf. wurde Wert im Nachhinein aber wieder entfernt
            if (jQuery(this).find("input[name=" + filterType + "]").val() != "") {
                searchData[filterType] = jQuery(this).find("input[name=" + filterType + "]").data(filterType);
                //console.log(filterType);
            }
        }
        // Dropdowns, also Status, Typ
        if (inputType == "dropdown") {
            searchData[filterType] = [];

            // Bestimmen aktiver Filterkategorien
            jQuery(filter).find(".multiselect-container li.active input[type=checkbox]").each(function () {
                searchData[filterType].push(jQuery(this).val());
            });
        }
        // Kennzeichen
        if (inputType == "tag") {

            jQuery(filter).find(".multiselect-container li.active input[type=checkbox]").each(function () {
                // Haupt-LI
                $parentLi = jQuery(this).parents("li");

                // Kennzeichen lesen
                let orderTagID = jQuery($parentLi).find("input[type=checkbox]").val();

                // Zugehörigen Wert finden
                let orderTagValue = jQuery($parentLi).find("input[data-additional-input=1]").val();

                if (orderTagValue == null) {
                    searchData["tags"][orderTagID] = null;
                }
                else {
                    searchData["tags"][orderTagID] = orderTagValue;
                }
            });
        }
        // Mehrere Input-Felder
        if (inputType == "multiText") {

            jQuery(this).find("input").each(function () {
                // name des Inputs bestimmen
                let inputName = jQuery(this).attr("name");
                // Wert holen
                searchData[inputName] = jQuery(this).val();
            });
        }
    });

    // Ggf. für Controlling noch Monat und Zeitspanne holen
    if (listType == "controllingMonthlyList") {
        searchData["month"] = jQuery("input[name=month]").val();
        searchData["year"] = jQuery("input[name=year]").val();
    }

    // Sonderfall: Checkbox "Kein Verantwortlicher"
    searchData["noResponsible"] = jQuery("input[name=noResponsible]").prop("checked");


    // Parameter aus Controller für Vorfilterung
    jQuery(".preFilters").find("input[type=hidden]").each(function () {
        let filterType = jQuery(this).data("filtertype");
        searchData[filterType] = jQuery(this).val();
    });

    //console.log(searchData);
    return searchData;

}

/* Sortierparameter auslesen */

/*
 * Auslesen von Sortierreihenfolge (aufsteigend, absteigend, keine) aus den Spalten der Listenkopfzeile, die die Klasse
 * headerSortLink besitzen.
 */
function getSortParameters() {

    let sortData = {};

    jQuery(".headerSortLink").each(function () {

        let sortStatus = jQuery(this).data("sortstatus");
        let sortId = jQuery(this).data("sortid");

        if (sortStatus != "none") {
            sortData[sortId] = sortStatus;
        }
    });

    if (Object.keys(sortData).length > 1) {
        // Id rauswerfen, sonst macht die Sortierung keinen Sinn
        delete sortData.id;
    }
    //console.log({sortData});
    return sortData;
}


/* Paginierung bauen */

/*
 * Anhand der Anzahl der Ergebnisse wird berechnet, wie viele Seiten vorgeblendet werden müssen.
 */
function buildPagination(numberCount, chosenPage) {
    // Grundgerüst + erste Seite
    let pagi = '<ul class="pagination" role="navigation">\n' +
        '<li class="page-item" data-pageNumber="0" aria-current="page"><a class="page-link" data-pageNumber="0">1</a></li>\n';

    // Nötige Seitenzahl berechnen und Paginierung erstellen , wenn nötig
    if (numberCount > entriesPerPage) {
        let pageNumber = Math.floor(numberCount / entriesPerPage);
        let remainder = numberCount - (pageNumber * entriesPerPage); // Überhang
        if (remainder > 0) pageNumber++;

        // Merker für Punkte
        let dots = false;
        let dotsBefore = false;
        let dotsAfter = false;

        for (counter = 1; counter < (pageNumber - 1); counter++) {

            // Gewählte Seite größer 3, dann wird die gewählte Seite flankiert von den je zwei darauffolgenden und denjenigen
            // vorher angezeigt, sonst nur Punkte sowie die erste und -letzte Seite
            if (chosenPage > 2) {

                // Seiten vorher
                if (counter < (chosenPage - 1)) {
                    if (dotsBefore == false) {
                        pagi += '<li class="page-item"><a class="page-link disabled" data-pageNumber="-1">...</a></li>';
                        dotsBefore = true; // Merken, dass Punkte gesetzt
                    }
                    continue;
                }

                // Seiten nachher
                if (counter > (chosenPage + 1)) {
                    if (dotsAfter == false) {
                        pagi += '<li class="page-item"><a class="page-link disabled" data-pageNumber="-1">...</a></li>';
                        dotsAfter = true; // Merken, dass Punkte gesetzt
                    }
                    continue;
                }
            }
            // Gewählte Seite kleiner gleich drei: Zeige Seiten 1-5 normal an, danach Punkte, dann letzte Seite
            else {
                if (counter >= 5 && counter < (pageNumber - 1)) {
                    if (dots == false) {
                        pagi += '<li class="page-item"><a class="page-link disabled">...</a></li>';
                        dots = true; // Merken, dass Punkte gesetzt
                    }
                    continue;
                }
            }

            // Seitenlink hinzufügen
            pagi += '<li class="page-item" data-pageNumber="' + counter + '"><a class="page-link" data-pageNumber="' + counter + '">' + (counter + 1) + '</a></li>\n';
        }

        // Letzte Seite immer anzeigen
        pagi += '<li class="page-item" data-pageNumber="' + counter + '"><a class="page-link" data-pageNumber="' + counter + '">' + (counter + 1) + '</a></li>\n';
    }
    pagi += '</ul>';

    return pagi;
}


/* Focus setzen abhängig vom Typ des Eingabeelements */
function setFocus(filterType, inputType) {
    // Focus entsprechend dem Eingabetyp setzen
    if (inputType == "text" || inputType == "textSearch" || inputType == "multiText") {
        jQuery(".filter-extended[data-filtertype=" + filterType + "] input").focus();
    }
    if (inputType == "dropdown") {
        jQuery(".filter-extended[data-filtertype=" + filterType + "] input[type='checkbox']:first").focus();
    }
    if (inputType == "tag") {
        jQuery(".filter-extended[data-filtertype=" + filterType + "]").focus();
    }
    if (inputType == "date") {
        jQuery(".filter-extended[data-filtertype=" + filterType + "] input[name=dateFrom]").focus();
    }
}

/* Live-Search nach Verantwortlichem */
/*
 * Während des Tippens im Input-Feld mit der ID searchResponsible wird per Ajax-Request nach einem passenden Bearbeiter
 * gesucht. Die Bearbeiter werden in einem Dropdown mit der Klasse liveSearchResults zur Auswahl angezeigt.
 */
jQuery(document).on('keyup', '#searchResponsible', function () {
    value = $(this).val();
    let url = '/searchOperator';

    // Bearbeiter suchen
    $.get(url + '/' + value, function (data) {

        // Suchergebnisse verarbeiten
        let operators = JSON.parse(data);

        // Ergebnisliste Element finden und leeren
        let resultList = jQuery(".filter-extended[data-filtertype=responsible]").find(".liveSearchResults");
        resultList.html("");

        if (operators.length == 0) {
            resultList.append("<div class='result'>Keine Ergebnisse.</div>");
        }
        // Links hinzufügen
        else {
            jQuery.each(operators, function (id, operator) {
                let newLink = "<a class='result chooseResponsibleFromSearch' data-operatorid='" + operator.id + "'>" + operator.name + " " + operator.firstname + "</a><br>";
                resultList.append(newLink);
            });
        }
    });
});

/* Live-Search nach Auftraggeber */
/*
 * Während des Tippens im Input-Feld mit der ID searchCustomer wird per Ajax-Request nach einem passenden Auftraggeber
 * gesucht. Die Auftraggeber werden in einem Dropdown mit der Klasse liveSearchResults zur Auswahl angezeigt.
 */
jQuery(document).on('keyup', '#searchCustomer', function () {
    value = $(this).val();
    let url = '/searchCustomer';

    // Auftraggeber suchen
    $.get(url + '/' + value, function (data) {

        // Suchergebnisse verarbeiten
        let customers = JSON.parse(data);

        // Ergebnisliste Element finden und leeren
        let resultList = jQuery(".filter-extended[data-filtertype=customer]").find(".liveSearchResults");
        resultList.html("");


        if (customers.length == 0) {
            resultList.append("<div class='result'>Keine Ergebnisse.</div>");
        }
        // Links hinzufügen
        else {
            jQuery.each(customers, function (company, customerID) {
                let newLink = "<a class='result chooseCustomerFromSearch' data-customerid='" + customerID + "'>" + company + "</a><br>";
                resultList.append(newLink);
            });
        }
    });
});


/* Bearbeiter aus den Live-Search-Ergebnissen auswählen */
/*
 * Wird ein Bearbeitername angeklickt, wird dessen ID in ein verstecktes Input-Feld für die Suche geschrieben.
 */
jQuery(document).on('click', 'a.chooseResponsibleFromSearch', function () {
    // ID lesen
    let operatorID = jQuery(this).data("operatorid");
    let name = jQuery(this).text();

    // ID als Datenattribut des Inputs setzen
    jQuery("input[name=responsible]").data("responsible", operatorID);

    // Namen als Input-Wert setzen
    jQuery("input[name=responsible]").val(name);

    // Ergebnisliste ausblenden
    jQuery(".filter-extended[data-filtertype=responsible]").find(".liveSearchResults").html("");
});

/* Auftraggeber aus den Live-Search-Ergebnissen auswählen */
/*
 * Wird ein Auftraggebername angeklickt, wird dessen ID in ein verstecktes Input-Feld für die Suche geschrieben.
 */
jQuery(document).on('click', 'a.chooseCustomerFromSearch', function () {

    // ID lesen
    let customerID = jQuery(this).data("customerid");
    let company = jQuery(this).text();

    // ID als Datenattribut des Inputs setzen
    jQuery("input[name=customer]").data("customer", customerID);

    // Firmennamen als Input-Wert setzen
    jQuery("input[name=customer]").val(company);

    // Ergebnisliste ausblenden
    jQuery(".filter-extended[data-filtertype=customer]").find(".liveSearchResults").html("");
});

// Livesearch ausblenden
jQuery(document).on('click', 'body', function () {
    jQuery(".filter-extended[data-filtertype=customer]").find(".liveSearchResults").html("");
    jQuery(".filter-extended[data-filtertype=responsible]").find(".liveSearchResults").html("");
});


/* Start der Auftragssuche */

/*
 * Holt sich Filter- und Sortierparameter und sucht im Anschluss per Ajax-Request nach passenden Aufträgen.
 * Bei erfolgreicher Suche wird pro Auftrag ein Listenauftrag in HTML generiert und in das DIV mit der ID
 * ordersListItems eingefügt. Im Anschluss daran wird die Paginierung erstellt und in das DIV mit der Klasse
 * searchPagination geschrieben; die aktuelle Seite wird gesetzt.
 *
 * Werden keine Aufträge gefunden, wird eine entsprechende Meldung angezeigt.
 * */
function startSearch(limit, offset, canCreateOrders, canEditOrders, canDeleteOrders, chosenPage, listType, hideSensibleOrderData) {
    chosenPage = typeof chosenPage !== 'undefined' ? chosenPage : 0;
    listType = typeof listType !== 'undefined' ? listType : "ordersList";
    hideSensibleOrderData = typeof hideSensibleOrderData !== 'undefined' ? hideSensibleOrderData : false;

    const orderFinishedStatusId = 7; // Bau erledigt
    const orderClosedStatusId = 4; // Abgeschlossen
    const orderPaymentFinalizedStatusId = 5; // Bezahlt
    const orderPaymentCreditEarnedStatusId = 4; // Gutschrift erhalten
    const orderStornoStatusId = 8;

    showLoadingSpinner();
    let searchData = getSearchParameters(listType);
    let sortData = getSortParameters();

    // Übergabeparameter als JSON codieren
    let transferSearchData = JSON.stringify(searchData);
    let transferSortData = JSON.stringify(sortData);


    // Ajax-Parameter festlegen
    let url = "/orders/search";
    var data = {
        "searchParameters": transferSearchData,
        "sortParameters": transferSortData,
        "limit": limit,
        "offset": offset
    };

    // Handling für erfolgreichen Request
    successFunction = function (response) {
        if (response.response == "success") {
            //console.log(response);
            // Auftragsliste leeren
            jQuery("#ordersListItems").html("");
            // Paginierung leeren
            jQuery(".searchPagination").html("");
            // Keine Ergebnisse ausblenden
            jQuery("#noSearchResults").removeClass("noSearchResultsShow");

            // Zusammenfassung leeren, wenn Controlling
            if (listType == "controllingMonthlyList") {
                // Zusammenfassung gesamt
                // Auftragsanzahl
                jQuery("#summaryValueTotalResult").html("0");
                // Wohneinheiten
                jQuery("#summaryValueTotalApartmentUnits").html("0");
                // Auftragswert
                jQuery("#summaryValueTotalSum span").html("0");
            }

            if (response.noResult === true) {
                jQuery("#noSearchResults").addClass("noSearchResultsShow");
            }
            else {
                let list = JSON.parse(response.returnOrders);

                // Für jeden zurückgegebenen Auftrag neue Zeile erstellen
                jQuery.each(list, function (index, order) {

                    // Bearbeiterliste erstellen
                    let operators = JSON.parse(order.responsibleOperators);

                    let operatorsList = '';
                    operatorsList = '<div class="col-2" data-content="responsible">\n';

                    if (Object.keys(operators).length > 0) {
                        jQuery.each(operators, function (operatorId, operatorName) {
                            operatorsList += '<div class="row"><a href="#" class="showResponsible" data-operatorid="' + operatorId + '">\n' +
                                '                ' + operatorName + '\n' +
                                '             </a></div>\n';
                        });
                    }
                    else operatorsList += 'Keiner';

                    operatorsList += '</div>\n';


                    if (listType == "ordersList") {

                        // Geocoordinaten
                        $dataGeoLatitude = "";
                        if(order.latitude != null)
                        {
                            $dataGeoLatitude = "data-geo-latitude='"+(order.latitude)+"'";
                        }
                        $dataGeoLongitude = "";
                        if(order.longitude != null)
                        {
                            $dataGeoLongitude = "data-geo-longitude='"+(order.longitude)+"'";
                        }
                        // Koordinaten nur rausschreiben, wenn beide Werte vorhanden sind
                        let newListEntry = '<div  class="row no-gutters align-items-start listItem searchItem \n';
                        if($dataGeoLatitude != "" && $dataGeoLongitude != "")
                        {
                            let info = '<a href=\'/order/' + order.id + '\'>Auftrag ' + order.order_number + '</a>';
                            info += '<br/>Wohneinheiten: ' + order.apartmentUnits;
                            info += '<br/><br/>' + order.location;

                            newListEntry = '<div data-geo-info="'+info+'" data-geo-link="/order/' + order.id + '" '+$dataGeoLatitude+' '+$dataGeoLongitude+' class="row no-gutters align-items-start listItem searchItem \n';
                        }

                        // Wenn der Auftrag (Bau) abgeschlossen oder bezahlt ist, farbig hinterlegen
                        if(order.statusid == orderStornoStatusId)
                        {
                            newListEntry += 'orderCanceled';
                        }
                        else if(order.payment_status_id == orderPaymentFinalizedStatusId)
                        {
                            newListEntry += 'orderPaymentFinised';
                        }
                        else if (order.statusid == orderFinishedStatusId || order.statusid == orderClosedStatusId || order.payment_status_id == orderPaymentCreditEarnedStatusId)
                        {
                            newListEntry += 'orderFinished';
                        }


                        newListEntry += '">' +

                            '                        <div class="col-1">\n' +
                            '                            <a href="/order/' + order.id + '" class="label">' + order.order_number + '</a>\n' +
                            '                        </div>\n' +
                            '\n';

                        if (hideSensibleOrderData == false) {
                            newListEntry += '        <div class="col-2">\n' +
                            '                            <a href="#" class="showCustomer" data-customerid="' + order.customerId + '">\n' +
                            '                                ' + order.customer + ' ' + order.customerLocation + '\n' +
                            '                            </a>\n' +
                            '                        </div>\n' +
                            '\n';
                        }

                        newListEntry += '            <div class="col-2" data-content="address">\n' +
                            '                                ' + order.location + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-1" style="padding-left:10px;">\n' +
                            '                            ' + order.apartmentUnits + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-1">\n' +
                            '                            ' + order.type + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            operatorsList +
                            '                        <div class="col-1">\n' +
                            '                            ' + order.created + '\n' +
                            '\n' +
                            '                        </div>\n' +
                            '\n';

                        if (hideSensibleOrderData == false) {
                            newListEntry += '        <div class="col-1">\n' +
                            '                            ' + order.appointment +
                            '                        </div>\n';
                        }

                        newListEntry += '            <div class="col-1">\n' +
                            '                            <div class="row no-gutters actions">\n' +
                            '\n';

                        if (canCreateOrders == true) {
                            //newListEntry +=
                                '                                <div class="">\n' +
                                '                                        <a href="/orders/copy/' + order.id + '"\n' +
                                '                                           title="Kopieren">\n' +
                                '                                            <i class="fal fa-copy"></i>\n' +
                                '                                        </a>\n' +
                                '                                </div>\n';
                        }
                        if (canEditOrders == true) {
                            newListEntry +=
                                '                                <div class="">\n' +
                                '                                        <a href="/order/' + order.id + '"\n' +
                                '                                           title="Bearbeiten">\n' +
                                '                                            <i class="fal fa-pencil-alt"></i>\n' +
                                '                                        </a>\n' +
                                '                                </div>\n';
                        }
                        newListEntry +=
                            '\n' +
                            '\n';

                        if (canDeleteOrders == true) {
                            newListEntry +=
                                '                                <div class="">\n' +
                                '                                        <a href="#"\n' +
                                '                                           data-orderid="' + order.id + '"\n' +
                                '                                           class="deleteOrder"\n' +
                                '                                           title="Löschen">\n' +
                                '                                            <i class="fal fa-trash-alt"></i>\n' +
                                '                                        </a>\n' +
                                '                                </div>\n' +
                                '\n' +
                                '\n' +
                                '                            </div>\n';
                        }
                        newListEntry +=
                            '                        </div>\n' +
                            '                    </div>';


                        jQuery("#ordersListItems").append(newListEntry);
                    }

                    else if (listType == "controllingMonthlyList") {

                        let newListEntry = '<div class="row no-gutters align-items-start listItem searchItem \n';

                        // Wenn der Auftrag (Bau) abgeschlossen oder bezahlt ist, farbig hinterlegen
                        if(order.statusid == orderStornoStatusId)
                        {
                            newListEntry += 'orderCanceled';
                        }
                        else if(order.payment_status_id == orderPaymentFinalizedStatusId)
                        {
                            newListEntry += 'orderPaymentFinised';
                        }
                        else if (order.statusid == orderFinishedStatusId)
                        {
                            newListEntry += 'orderFinished';
                        }

                        newListEntry += '">' +
                            '                        <div class="col-1">\n' +
                            '                            <a href="/order/' + order.id + '" class="label">' + order.order_number + '</a>\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-3">\n' +
                            '                            <a href="#" class="showCustomer" data-customerid="' + order.customerId + '">\n' +
                            '                                ' + order.customer + ' ' + order.customerLocation + '\n' +
                            '                            </a>\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-2">\n' +
                            '                            ' + order.type + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            operatorsList +
                            '\n' +
                            '                        <div class="col-1">\n' +
                            '                            ' + order.apartmentUnits + '\n' +
                            '                        </div>\n' +
                            '\n' +

                            '                        <div class="col-2">\n' +
                            '                            EUR ' + order.orderValue + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-1">\n' +
                            '                            <div class="row no-gutters">\n' +
                            '\n';

                        if (canEditOrders == true) {
                            newListEntry +=
                                '                                <div class="">\n' +
                                '                                        <a href="/order/' + order.id + '"\n' +
                                '                                           title="Bearbeiten">\n' +
                                '                                            <i class="fal fa-pencil-alt"></i>\n' +
                                '                                        </a>\n' +
                                '                                </div>\n';
                        }


                        newListEntry +=
                            '                        </div>\n' +
                            '                    </div>';


                        jQuery("#ordersListItems").append(newListEntry);

                        // Zusammenfassung gesamt
                        // Auftragsanzahl
                        jQuery("#summaryValueTotalResult").html(response.totalResult);
                        // Wohneinheiten
                        jQuery("#summaryValueTotalApartmentUnits").html(response.totalApartmentUnits);
                        // Auftragswert
                        let totalSum = response.totalSum.toString();
                        totalSum = totalSum.replace(".", ",");

                        jQuery("#summaryValueTotalSum span").html(totalSum);
                    }
                    else if (listType == "controllingList") {

                        let newListEntry = '<div class="row no-gutters align-items-start listItem searchItem \n';

                        // Wenn der Auftrag (Bau) abgeschlossen oder bezahlt ist, farbig hinterlegen
                        if(order.statusid == orderStornoStatusId)
                        {
                            newListEntry += 'orderCanceled';
                        }
                        else if(order.payment_status_id == orderPaymentFinalizedStatusId)
                        {
                            newListEntry += 'orderPaymentFinised';
                        }
                        else if (order.statusid == orderFinishedStatusId)
                        {
                            newListEntry += 'orderFinished';
                        }

                        newListEntry += '">' +
                            '                        <div class="col-1">\n' +
                            '                            <a href="/order/' + order.id + '" class="label">' + order.order_number + '</a>\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-2">\n' +
                            '                            ' + order.type + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-2">\n' +
                            '                            ' + order.status + '\n' +
                            '                        </div>\n' +
                            operatorsList +
                            '\n' +
                            '                        <div class="col-2">\n' +
                            '                            ' + order.payment_status + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                        <div class="col-1 text-right">\n' +
                            '                           ' + order.created + '\n' +
                            '                        </div>\n' +
                            '\n' +

                            '                        <div class="col-2 text-right">\n' +
                            '                           ' + order.end_date + '\n' +
                            '                        </div>\n' +
                            '\n' +
                            '                    </div>';


                        jQuery("#ordersListItems").append(newListEntry);

                        // Zusammenfassung gesamt
                        // Auftragsanzahl
                        jQuery("#summaryValueTotalResult").html(response.totalResult);
                        // Wohneinheiten
                        jQuery("#summaryValueTotalApartmentUnits").html(response.totalApartmentUnits);
                        // Auftragswert
                        let totalSum = response.totalSum.toString();
                        totalSum = totalSum.replace(".", ",");

                        jQuery("#summaryValueTotalSum span").html(totalSum);
                    }
                });

                // Pagination erstellen (außer bei Gesamtübersicht Controlling)
                if (listType != "controllingList")
                    jQuery("div.searchPagination").html(buildPagination(response.totalResult, chosenPage));

                if (listType == "ordersList")
                    generateGoogleMaps();

                // Aktive Seite setzen
                jQuery(".searchPagination li[data-pagenumber=" + chosenPage + "]").addClass("active");
            }

            hideLoadingSpinner();
        }
        else {
            errorFunction(response);
        }
        configureResponsiveTables();
    };

    // Handling für fehlerhaften Request
    errorFunction = function (response) {
        showModalBox("Es ist ein Fehler aufgetreten.", response.message);
        hideLoadingSpinner();
    };

    // Ajax aufrufen
    fireAjax(url, data, successFunction, errorFunction);
}

/*
Die Funktion generiert eine Google Maps Karte aus bestehenden listItem - Elementen, welche Geo-Koordinaten hinterlegt haben
 */
function generateGoogleMaps()
{
    $mapElements = jQuery(".listItem[data-geo-latitude][data-geo-longitude]");
    //console.log("karten elemente:"+jQuery($mapElements).length);

    var locations = [];

    jQuery.each($mapElements, function( index, value ) {

        var latitude = jQuery(value).data("geo-latitude");
        var longitude = jQuery(value).data("geo-longitude");
        var infotext = jQuery(value).data("geo-info");
        var link = jQuery(value).data("geo-link");

        var newElement = [latitude, longitude, infotext, link];
        locations.push(newElement);
    });

    if(locations.length > 0)
    {
        // Map in das HTML hinzufügen
        if(jQuery("#map").length == 0)
            jQuery("<div id=\"map\"></div>").insertBefore("#listToSearch");

        //console.log(locations);
        initMap(locations);
    }
}


function initMap(locations) {

    if(typeof locations == "undefined" )
    {
        return true;
    }

    var myLatLng = {lat: 49.67299, lng: 12.1555147};
    var bounds = new google.maps.LatLngBounds();

    var map = new google.maps.Map(document.getElementById('map'), {
        zoom: 14,
        center: myLatLng
    });

    var count;
    var contentString;
    var infowindow;

    for (count = 0; count < locations.length; count++) {
        var marker = new google.maps.Marker({
            position: new google.maps.LatLng(locations[count][0], locations[count][1]),
            map: map,
            title: ''
        });

        var infoWindow = new google.maps.InfoWindow();
        // Add info window to marker
        google.maps.event.addListener(marker, 'mouseover', (function(marker, count) {
            return function() {
                infoWindow.setContent(locations[count][2]);
                infoWindow.open(map, marker);
            }
        })(marker, count));


        google.maps.event.addListener(marker, 'dblclick', (function(marker, count) {
            return function() {
                window.location.href=locations[count][3];
            }
        })(marker, count));

        //extend the bounds to include each marker's position
        bounds.extend(marker.position);

    }
    map.fitBounds(bounds);
}