jQuery( document ).ready(function() {

  configureResponsiveTables();

});


function configureResponsiveTables(){
  // Alle iTables für responsive Darstellung selektieren
  let iTables = jQuery("[data-itable='1']");
  if (iTables.length >= 1)
  {
    jQuery(iTables).each(function()
    {
      // Selektieren aller header
      let headerTitles = [];
      let headers = jQuery(this).find(".listHeader>div");
      if (headers.length >= 1)
      {
        jQuery(headers).each(function()
        {
          let title = jQuery(this).html().replace(/\r?\n|\r/, "").replace(".","").trim();
          if(jQuery(title).text() != title && jQuery(title).text() != "")
            title = jQuery(title).text();

          headerTitles.push(title);
        });

        // Allen Elementen die Headercaption zuordnen
        let listItems = jQuery(this).find(".listItem");
        if (listItems.length >= 1)
        {
          jQuery(listItems).each(function()
          {
            // Alle Spalten durchgehen von links nach rechts
            for (var i = 0; i < headers.length; i++)
            {
              let attr = jQuery(this).find(">div:nth-child("+(i+1)+")").attr("data-th");
              if ((typeof attr !== typeof undefined && attr !== false) == false)
              {
                // Element hat das Attribut noch nicht
                jQuery(this).find(">div:nth-child("+(i+1)+")").attr("data-th", headerTitles[i]);
              }
            }
          });
        }
      }
    });
  }
}
