{!!BootForm::open(["id" => "changeUserRights",
                   "route" => array('clientAdmin.changeUserRights'),
                   "method" => "POST",
                   "enctype" => "multipart/form-data"])!!}
<input type="hidden" name="userToEdit" value="{{ $userToEdit->id }}">

<header>Rechte bearbeiten: {{ $userToEdit->getName() }}</header>


<div class="container">
    <ul class="nav nav-tabs" id="rightsGroupsTab" role="tablist">
        @foreach($rightsGroups as $rightsGroupKey => $rightsGroup)
            <li class="nav-item">
                <a class="nav-link @if($loop->first) active @endif" id="{{ $rightsGroupKey }}-tab" data-toggle="tab"
                   href="#tab{{ $rightsGroupKey }}" role="tab" aria-controls="{{ $rightsGroupKey }}"
                   aria-selected="true">{{ $rightsGroup["name"] }}</a>
            </li>
        @endforeach
    </ul>


    <div class="tab-content" id="rightsGroupsTabContent">
        @csrf
        @foreach($rightsGroups as $rightsGroupKey => $rightsGroup)
            <div class="tab-pane fade @if($loop->first) show active @endif" id="tab{{ $rightsGroupKey }}"
                 role="tabpanel" aria-labelledby="{{ $rightsGroupKey }}-tab">

                <div class="row no-gutters rightsGroupMaster">
                    <div class="col-9">
                        <div class="row">
                            <div class="col-12 rightsGroupName">
                                {{ $rightsGroup["name"] }}
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 rightsGroupDesc">
                                {{ $rightsGroup["description"] }}
                            </div>
                        </div>
                    </div>


                    {{-- Die "Master-Checkbox" einer Rechtegruppe macht nur Sinn, wenn es mehr als ein Recht gibt --}}
                    @if(sizeof($rightsGroup["rights"]) > 1)
                        <div class="col-2 offset-1">
                            <label class="toggleCheckbox">
                                <input type="checkbox" class="masterCheckbox"
                                       name="{{$rightsGroupKey}}" {{$rightsGroup["hasAllRights"]}}>
                                <i class="bigger"></i>
                            </label>
                        </div>

                    @endif
                </div>

                <div class="row">
                    <div class="col-md-12">
                        @foreach($rightsGroup["rights"] as $rightKey => $right)
                            <div class="row align-items-center right">
                                <div class="col-10">
                                    <div class="row rightName">
                                        {{ $right["label"] }}
                                    </div>
                                    <div class="row rightDesc">
                                        {{ $right["description"] }}
                                    </div>
                                </div>
                                <div class="col-2">
                                    <label class="toggleCheckbox {{ $rightsGroupKey }}">
                                        <input type="checkbox" name="checkbox_{{ $rightKey }}"
                                                {{ $right["hasRight"] }}>
                                        <i></i>
                                    </label>
                                </div>

                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="row"><p></p></div>
</div>


<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>


<script>
    jQuery(function () {
        // Globale Checkbox zum aus-/abwählen aller Rechte in der Gruppe
        jQuery(".masterCheckbox").click(function () {
            jQuery("." + this.name + " input[type='checkbox']").attr("checked", jQuery(this).prop("checked"));
        });

        // Bei zuweisen/wegnehmen von Mandantenadministrationsrechten auch alle anderen Checkboxen aktivieren/deaktivieren
        jQuery("input[name='checkbox_2']").click(function () {
            jQuery("#rightsGroupsTabContent input[type='checkbox'][name!='checkbox_1']").attr("checked", jQuery(this).prop("checked"));
        });

        jQuery("input[name='checkbox_1']").click(function () {
            jQuery("#rightsGroupsTabContent input[type='checkbox'][name!='checkbox_1']").attr("checked", jQuery(this).prop("checked"));
        });

    });
</script>

{!!BootForm::close()!!}