@extends('layouts.master')

<?php
use Carbon\Carbon;

$c = Carbon::now();
$month = $c->month;
$year = $c->year;
?>

@section('content')


    <main class="contentContainer">

        <h1>Controlling - Monatsübersicht</h1>

        <div class="row">
            <div class="col-12 col-lg-6 monthBar">
                <span class="month"></span> <span class="year"></span>
            </div>
            <div class="col-12 col-lg-6 text-right monthSwitch">
                <i data-action="prev" class="fas fa-2x fa-chevron-left"></i>
                <i data-action="next" class="fas fa-2x fa-chevron-right"></i>
            </div>
        </div>

        <input type="hidden" name="month" value="{{ $month }}">
        <input type="hidden" name="year" value="{{ $year }}">

        @include('order.sections.filterSection')

        <div class="clearfix">&nbsp;</div>

        <div class="row ordersList" id="listToSearch" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters operatorListHeader listHeader">
                    <div class="col-1">
                        <a class="headerSortLink" data-sortStatus="desc" data-sortid="order_number">
                            A-Nr.
                            <span class="sortSymbol"><i class="fas fa-sort-down"></i></span>
                        </a>
                    </div>
                    <div class="col-3">
                        <a class="headerSortLink" data-sortStatus="none" data-sortid="customer_id">
                            Auftraggeber
                            <span class="sortSymbol"><i class="fal fa-sort"></i></span>
                        </a>
                    </div>
                    <div class="col-2">
                        <a class="headerSortLink" data-sortStatus="none" data-sortid="order_types_id">
                            Auftragstyp
                            <span class="sortSymbol"><i class="fal fa-sort"></i></span>
                        </a>
                    </div>
                    <div class="col-2">
                        Verantwortliche
                    </div>
                    <div class="col-1">
                        <a class="headerSortLink" data-sortStatus="none" data-sortid="apartment_units">
                            W.E.
                            <span class="sortSymbol"><i class="fal fa-sort"></i></span>
                        </a>
                    </div>
                    <div class="col-2">
                        <a class="headerSortLink" data-sortStatus="none" data-sortid="order_value">
                            Auftragswert
                            <span class="sortSymbol"><i class="fal fa-sort"></i></span>
                        </a>
                    </div>
                    <div class="col-1">
                        Aktionen
                    </div>
                </div>
                <div id="ordersListItems">

                </div>
                <div id="noSearchResults" class="row">
                    <div class="col-12 text-center">
                        Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
                    </div>
                </div>
            </div>
        </div>

        <div class="searchPagination">

        </div>

        @include('controlling.sections.summary')

    </main>

    @include('layouts.overlay')


    <script>
        let listType = "controllingMonthlyList";
    </script>

    @include('order.sections.generalListCode')

    <script>
        let months = ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];

        jQuery(function () {
            setMonthYearLabels();
        });

        function setMonthYearLabels() {
            // Monat und Jahr setzen
            let currentMonth = jQuery("input[name=month]").val();
            jQuery("span.month").html(months[currentMonth - 1]);
            let currentYear = jQuery("input[name=year]").val();
            jQuery("span.year").html(currentYear);
        }

        jQuery(document).on('click', '.monthSwitch i', function () {

            let action = jQuery(this).data("action");

            let currentMonth = parseInt(jQuery("input[name=month]").val());
            let currentYear = parseInt(jQuery("input[name=year]").val());
            let newMonth = 0;
            let newYear = 0;

            if (action == "next") {

                if (currentMonth == 12) {
                    newMonth = 1;
                    newYear = currentYear + 1;
                }
                else {
                    newMonth = currentMonth + 1;
                    newYear = currentYear;
                }
            }
            else if (action == "prev") {

                if (currentMonth == 1) {
                    newMonth = 12;
                    newYear = currentYear - 1;
                }
                else {
                    newMonth = currentMonth - 1;
                    newYear = currentYear;
                }
            }

            // Neue Monats- und Jahrdaten setzen
            jQuery("input[name=month]").val("");
            jQuery("input[name=month]").val(newMonth);
            jQuery("input[name=year]").val(newYear);

            setMonthYearLabels();

            startSearch(entriesPerPage, 0, canCreateOrders, canEditOrders, canDeleteOrders, 0, listType);
        });
    </script>
@endsection
