@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;

$arr = array();
$arr["customer"] = 5; #dd(serialize($arr));

$ser = serialize($arr);
?>

@section('content')
    <main class="contentContainer">

        <h1>Kunden</h1>
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12 col-md-3 text-center">
                        @if(UserController::checkRight("createCustomers", $user))
                            <a class="button editCustomer"
                               href="#"
                               data-customerid="0">Neuen Kunden
                                anlegen</a>
                        @endif
                    </div>
                    <div class="col-12 col-md-3 offset-md-6 text-right">
                        @if(count($customerList) > 0)
                            <input type="text" class="slide-input search" id="searchFor" autocomplete="off"
                                   data-shownosearchresults="noCustomers">
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" id="customerList" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-1">
                        Nr.
                    </div>
                    <div class="col-5">
                        Kunde
                    </div>
                    <div class="col-4">
                        Kontakt
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @if(count($customerList) > 0)
                    @foreach($customerList as $customer)
                        <div class="row no-gutters align-items-center listItem searchItem"
                             data-search-for="{{ $customer->company }} {{ $customer->name }} {{ $customer->firstname }}">

                            <div class="col-1">
                                <a data-customerid="{{ $customer->id }}"
                                   class="editCustomer cursorPointer"
                                   title="Bearbeiten">
                                    {{ $customer->customer_number }}
                                </a>
                            </div>

                            <div class="col-5 label">
                                <a data-customerid="{{ $customer->id }}"
                                   class="editCustomer cursorPointer"
                                   title="Bearbeiten">
                                    {{ $customer->company }}@if($customer->place != ""), {{ $customer->place }}@endif
                                </a>
                            </div>

                            <div class="col-4">
                                <div class="row">
                                    <div class="">
                                        @if($customer->name != "" && $customer->email != "")
                                            <a href="mailto:{{ $customer->email }}">{{ $customer->title }} {{ $customer->firstname }} {{ $customer->name }}</a>
                                        @elseif($customer->name != "" && $customer->email == "")
                                            {{ $customer->title }} {{ $customer->firstname }} {{ $customer->name }}
                                        @elseif($customer->name == "" && $customer->email != "")
                                            <a href="mailto:{{ $customer->email }}">{{ $customer->email }}</a>
                                        @else
                                            -
                                        @endif
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="">
                                        @if($customer->telephone_number != "")
                                            Tel.: {{ $customer->telephone_number }}
                                        @endif
                                    </div>
                                </div>
                            </div>


                            <div class="col-2">
                                <div class="row no-gutters">


                                    <div class="">
                                        @if(UserController::checkRight("editCustomers", $user))
                                            <a href="#"
                                               data-customerid="{{ $customer->id }}"
                                               class="editCustomer"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>
                                    <div class="">
                                        @if(UserController::checkRight("seeOrdersList", $user))
                                            <a href="{{ route('orders.list', ["customerId" => $customer->id])}}"
                                               data-customerID="{{ $customer->id }}"
                                               class="showCustomerOrderList"
                                               title="Auftragsliste anzeigen">
                                                <i class="fal fa-clipboard-list"></i>
                                            </a>
                                        @endif
                                    </div>
                                    <div class="">
                                        @if($customer->email != "")
                                            <a href="mailto:{{ $customer->email }}"
                                               class="mailCustomer"
                                               title="E-Mail schreiben">
                                                <i class="fal fa-envelope"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div class="row noListEntries">
                        <div class="col-12 text-center">
                            Keine Auftraggeber hinterlegt.
                        </div>
                    </div>
                @endif
                <div data-nosearchresults="noCustomers" class="row">
                    <div class="col-12 text-center">
                        Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
                    </div>
                </div>
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <script>

        jQuery(document).ready(function () {

            // Neuen Auftraggeber anlegen / Bestehenden bearbeiten
            jQuery(".editCustomer").click(function () {
                showLoadingSpinner();

                let url = "/customer";
                let customer_id = jQuery(this).data("customerid");

                $.get(url + '/' + customer_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        error = true;
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

        });
    </script>
@endsection
