@extends('layouts.master')

@section('content')
    <?php
    use App\Library\DropzoneMulti;

    $dropzoneOptions = array(
        "thumbnailWidth" => 93,
        "thumbnailHeight" => 93,
    );

    $animationIcon = "fas fa-music";

    $dropzoneMulti = new DropzoneMulti($dropzoneOptions,
        "multiDropzoneRelatedForm",
        "anotherMultiDropzone",
        $route = "default",
        true, $animationIcon);
    ?>

    <main class="contentContainer">
        <h1>Demo Dropzone mit mehreren Bildern</h1>

        <div class="row">
            <div class="col-md-6">
                <?php
                echo $dropzoneMulti->getDropzoneForm();
                ?>
            </div>
            <div class="col-md-6">
                <h2>Zugehöriges Formular</h2>
                {!! BootForm::open([
                                    #"route" => array('dropzoneDemo.processDummyForm'),
                                     "method" => "POST" , "id" => "multiDropzoneRelatedForm"]); !!}

                {!! BootForm::input("text", "Testfeld"); !!}

                <input type="text" name="newFiles"
                       value='{ "files": [] }'>

                {!! BootForm::submit() !!}
                {!! BootForm::close(); !!}
            </div>
        </div>
    </main>

    <?php
    echo $dropzoneMulti->getDropzoneJSCode();
    ?>
@endsection
