@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')
    <main class="contentContainer">

        <h1>Nummernkreise</h1>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-6">
                        Nummernkreis
                    </div>
                    <div class="col-5">
                        Aktueller Stand
                    </div>
                </div>
                @if(count($numberRanges) > 0)
                    @foreach($numberRanges as $numberRange)

                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-6 label">
                                <a data-numberrangeid="{{ $numberRange->id }}"
                                   class="editNumberRange cursorPointer"
                                   title="Bearbeiten">{{ $numberRange->key_label }}</a>
                            </div>

                            <div class="col-5">
                                {{ $numberRange->current_number }}
                            </div>

                            <div class="col-1">
                                <div class="row no-gutters">
                                    <div class="">
                                        @if(UserController::checkRight("editNumberRanges", $user))
                                            <a href="#"
                                               data-numberrangeid="{{ $numberRange->id }}"
                                               class="editNumberRange"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Nummernkreise hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')

    <script>
        // Nummernkreis bearbeiten
        jQuery(".editNumberRange").click(function () {
            showLoadingSpinner();

            let url = "/numberrange";
            let numberrange_id = jQuery(this).data("numberrangeid");

            $.get(url + '/' + numberrange_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    error = true;
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });


    </script>


@endsection
