@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')
    <main class="contentContainer">

        <h1>Arbeitsanweisungen</h1>


        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                @if(UserController::checkRight("createOrderType", $user))
                    <a class="button editOperatingInstruction"
                       href="#"
                       data-operatinginstructionid="0">Neue Arbeitsanweisung anlegen</a>
                @endif
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-5">
                        Arbeitsanweisung
                    </div>
                    <div class="col-5">
                        Hinterlegte Dokumente
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @if(count($operatingInstructionList) > 0)
                    @foreach($operatingInstructionList as $operatingInstruction)
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-5 label">
                                {{ $operatingInstruction->title }}
                            </div>

                            <div class="col-5">
                                <i class="fas fa-file-powerpoint" style="margin-right:0; font-size:1.2em; color:#df7e1b;"></i> <span>PowerPoint</span> <span class="badge badge-pill badge-light">15</span> <br>
                                <i class="fas fa-file-word" style="margin-right:0; font-size:1.2em;color:#2230d5;"></i> Word <span class="badge badge-pill badge-light">2</span> <br>
                                <i class="fas fa-file-excel" style="margin-right:0; font-size:1.2em;color:#138b13;"></i> Excel <span class="badge badge-pill badge-light">3</span> <br>
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">
                                    <div class="">
                                        @if(UserController::checkRight("editOperatingInstruction", $user))
                                            <a href="#"
                                               data-operatinginstructionid="{{ $operatingInstruction->id }}"
                                               class="editOperatingInstruction"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteOperatingInstruction", $user))
                                            <a href="#"
                                               data-operatingInstructionid="{{ $operatingInstruction->id }}"
                                               class="deleteOperatingInstruction"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Arbeitsanweisungen hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <script>

        jQuery(function () {
            // Auftragstyp anlegen/bearbeiten: Overlay öffnen
            jQuery(".editOperatingInstruction").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/operatinginstruction';
                var data = {};
                data["operatingInstructionId"] = jQuery(this).data("operatinginstructionid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Auftragstyp löschen: Overlay öffnen
            jQuery(".deleteOperatingInstruction").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/operatinginstruction/deleteConfirm';
                var data = {};
                data["operatingInstructionId"] = jQuery(this).data("operatinginstructionid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });

        });
    </script>


@endsection
