<?php
use App\Http\Controllers\UserController;
use App\Library\Dropzone;
use Illuminate\Support\Facades\Storage;

$dropzoneOptions = ["thumbnailWidth" => 95,
    "thumbnailHeight" => 95,
];

if ($operator->id == NULL) {
    $mode = "create";
    $operatorImageDropzone = new Dropzone($dropzoneOptions, "editOperator", "operatorImageForm", "default", false);
}
else {
    $mode = "edit";
    $operatorImageDropzone = new Dropzone($dropzoneOptions, "editOperator", "operatorImageForm", "default", true, $operator->getImage());
}

if ($mode == "edit")
    $route = "edit";
else
    $route = "new";
?>

<header>Bearbeiter @if($mode=="create") anlegen @elseif($mode=="edit") {{ $operator->getName() }}
    bearbeiten @endif</header>

<div class="alertContainer">
    <div class="alert alert-danger">
        <div class="alertIcon">
            <i class="far fa-exclamation-circle"></i>
        </div>
        <div class="errorMessage">
            <ul>
                <li></li>
            </ul>
        </div>
    </div>
</div>
<div class="container">
    <div class="row">
        <div class="col-12">

            <div class="row">
                <div class="col-12">
                    <?php
                    echo $operatorImageDropzone->getDropzoneForm();
                    ?>
                </div>
            </div>
            <div class="row">&nbsp;</div>

            <form id="editOperator" action="javascript:void(0);">

                <input type="hidden" id="operator_id" name="operator_id" value="{{ $operator->id }}">

                <input type="hidden" name="deleteFile" value="0">

                <input type="hidden" name="newFile" value="">

                <div class="form-group row">
                    <label for="name" class="col-12 col-lg-4 col-form-label">Name</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="name" name="name"
                               value="{{ $operator->name }}">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="firstname" class="col-12 col-lg-4 col-form-label">Vorname</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="firstname" name="firstname"
                               value="{{ $operator->firstname }}">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="company" class="col-12 col-lg-4 col-form-label">Firma (extern)</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="company" name="company"
                               value="{{ $operator->company }}">
                    </div>
                </div>


                <div class="form-group row">
                    <label for="email" class="col-12 col-lg-4 col-form-label">E-Mail-Adresse</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="email" name="email"
                               value="{{ $operator->email }}">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="phone" class="col-12 col-lg-4 col-form-label">Telefonnummer</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="phone" name="phone"
                               value="{{ $operator->phone }}">
                    </div>
                </div>

                <div class="form-group row">
                    <label for="position" class="col-12 col-lg-4 col-form-label">Position</label>
                    <div class="col-12 col-lg-8">
                        <input type="text"
                               class="form-control"
                               id="position" name="position"
                               value="{{ $operator->position }}">
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editOperator" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

<?php
echo $operatorImageDropzone->getDropzoneJSCode();
?>

<script>
    jQuery(document).ready(function () {

        jQuery("button[type=submit]").click(function () {

            var url = "/operator/{{ $route }}";
            var data = {};

            data["operator_id"] = jQuery("input[name='operator_id']").val();
            data["name"] = jQuery("input[name='name']").val();
            data["firstname"] = jQuery("input[name='firstname']").val();
            data["company"] = jQuery("input[name='company']").val();
            data["email"] = jQuery("input[name='email']").val();
            data["phone"] = jQuery("input[name='phone']").val();
            data["position"] = jQuery("input[name='position']").val();
            data["newFile"] = jQuery("input[name='newFile']").val();
            data["deleteFile"] = jQuery("input[name='deleteFile']").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                type: 'post',
                url: url,
                data: data,
                dataType: 'json',
                success: function (data) {
                    if (data.response == "success") {
                        jQuery("#closeListEditor").trigger("click");

                        // Wenn die Funktion innerhalb einer Auftragsliste aufgerufen wird, muss nur der Name des
                        // Verantwortlichen aktualisiert werden
                        if (jQuery("div.ordersList").length > 0) {
                            showModalBox("Speichern erfolgreich", "Daten des Bearbeiters " + jQuery("input[name='name']").val() + " " + jQuery("input[name='firstname']").val() + " gespeichert.");
                            jQuery("a.showResponsible[data-operatorid=" + jQuery("input[name='operator_id']").val() + "]")
                                .text(jQuery("input[name='name']").val() + " " + jQuery("input[name='firstname']").val());
                        }

                        // In der Bearbeiterliste Erfolgsmeldung anzeigen und Seite neu laden
                        else {
                            showModalBox("Speichern erfolgreich", "Daten des Bearbeiters " + jQuery("input[name='name']").val() + " " + jQuery("input[name='firstname']").val() + " gespeichert.");
                            jQuery("#modalBox").data("reload", "true");
                        }
                    }
                    else {
                        //console.log(data);
                        showOverlayAlert(data.message);
                    }
                },
                error: function (data) {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    showOverlayAlert(data.message);
                }
            });
        });
    });

</script>


