@extends('layouts.master')

<?php
use App\Operator;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\UserController;
?>

@section('content')


    <main class="contentContainer">

        <h1>Bearbeiter</h1>

        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-12 col-md-3 text-center">
                        @if(UserController::checkRight("createOperators", $user))
                            <a class="button editOperator"
                               href="#"
                               data-operatorid="0">Neuen Bearbeiter anlegen</a>
                        @endif
                    </div>

                    <div class="col-12 col-md-3 offset-md-6 text-right">
                        <input type="text" class="slide-input search" id="searchFor" autocomplete="off"
                               data-shownosearchresults="noOperators">
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row operatorList" id="listToSearch" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters operatorListHeader listHeader">
                    <div class="col-4" style="padding-left:0px;">
                        Bearbeiter
                    </div>
                    <div class="col-3">
                        Kontakt
                    </div>
                    <div class="col-3">
                        Firma
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @foreach($operatorList as $operator)
                    <div class="row no-gutters align-items-center searchItem listItem"
                         data-search-for="{{$operator->name}} {{$operator->firstname}}">


                        <div class="col-4">
                            <div class="row">
                                <div class="col-2 itablehidemobile">
                                    <div class="img"
                                         style="background-image: url('{{ $operator->getImage() }}');"></div>
                                </div>
                                <div class="col-10 mb-auto mt-auto">
                                    <div class="row">
                                        <div class="col-12 label">
                                            <a class="editOperator cursorPointer"
                                               data-operatorid="{{ $operator->id }}"
                                               title="Bearbeiten">
                                                {{ $operator->getName() }}
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            @if($operator->position == "" && $operator->company != "")
                                                Extern
                                            @else
                                                {{ $operator->position }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-3">
                            @if($operator->email == "" && $operator->phone == "")
                                -
                            @else
                                <div class="row no-gutters">
                                    <div class="col-12">
                                        <a href="mailto:{{ $operator->email }}">{{ $operator->email }}</a>
                                    </div>
                                </div>
                                <div class="row no-gutters">
                                    <div class="col-12">
                                        @if($operator->phone != "")
                                            Tel.: {{ $operator->phone }}
                                        @endif
                                    </div>
                                </div>

                            @endif
                        </div>

                        <div class="col-3">
                            @if(isset($operator->company)) {{ $operator->company }}@endif
                        </div>

                        <div class="col-2">
                            <div class="row no-gutters">

                                <div class="">
                                    @if(UserController::checkRight("editOperators", $user))
                                        <a href="#"
                                           data-operatorid="{{ $operator->id }}"
                                           class="editOperator"
                                           title="Bearbeiten">
                                            <i class="fal fa-pencil-alt"></i>
                                        </a>
                                    @endif
                                </div>

{{--                                <div class="">--}}
{{--                                    @if(UserController::checkRight("seeOperatorCalendar", $user))--}}
{{--                                        <a href="{{ route('operator.calendar.list', ["operatorId" => $operator->id]) }}"--}}
{{--                                           id="{{ $operator->id }}"--}}
{{--                                           class="seeOperatorCalendar"--}}
{{--                                           title="Kalender anzeigen">--}}
{{--                                            <i class="fal fa-calendar-alt"></i>--}}
{{--                                        </a>--}}
{{--                                    @endif--}}
{{--                                </div>--}}

                                <div class="">
                                    @if(UserController::checkRight("createUser", $user) && $operator->user==null)
                                        <a href="#"
                                           data-operatorid="{{ $operator->id }}"
                                           class="createUser"
                                           title="Benutzer erstellen">
                                            <i class="fas fa-user-plus"></i>
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                @endforeach
                <div data-nosearchresults="noOperators" class="row">
                    <div class="col-12 text-center">
                        Zu dieser Eingabe gibt es leider keine Ergebnisse. Bitte versuche es erneut.
                    </div>
                </div>
            </div>
        </div>

    </main>


    @include('layouts.overlay')


    <script>

        jQuery(function () {
            // Neuen Auftraggeber anlegen / Bestehenden bearbeiten
            jQuery(".editOperator").click(function () {
                showLoadingSpinner();

                let url = "/operator";
                let operator_id = jQuery(this).data("operatorid");

                $.get(url + '/' + operator_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

            // Benutzer erstellen
            jQuery(".createUser").click(function () {
                showLoadingSpinner();

                let url = "/operator/newUserConfirm";
                let operator_id = jQuery(this).data("operatorid");

                $.get(url + '/' + operator_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });
        });
    </script>
@endsection
