@extends('layouts.master')
<?php
use App\Library\DropzoneMulti;
use App\Http\Controllers\UserController;
use App\User;

$orderDocumentsDropzoneOptions = [
    'acceptedFiles' => '"image/*,application/pdf,application/msword,application/vnd.ms-powerpoint,application/vnd.ms-excel,.xlsx,.xls,.doc,.docx,.ppt,.pptx"',
    'maxFilesize' => 50,
    'maxFiles' => 5
];

$orderDocumentsDropzone = new DropzoneMulti(
    $orderDocumentsDropzoneOptions,
    "editOrder",
    "editOrderDocumentsDropzone",
    "default", true, "fas fa-file"
);

?>

@section('content')
    <main class="contentContainer">

        <h1>Auftrag bearbeiten</h1>

        <button type="button" class="btn btn-primary btn-big additionalOrderSubmit"
                style="position: absolute; right: 10px; top: 10px;">
            Auftrag speichern
        </button>

        {!! BootForm::open(["id" => "editOrder",
                             "route" => "orders.update",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}

        <input type="hidden" name="orderToEdit" value="{{ $orderToEdit->id }}">


        {{-- 14.01.2019 / DS / Sensible Datenbereiche ausblenden, wenn hideSensibleOrderData == true --}}
        @if(!UserController::checkRight("hideSensibleOrderData", $user))
            <div class="row" data-itable='1'>
                <div class="col-12 col-lg-6"><h3>Wiedervorlagen</h3></div>
                <div class="col-12 col-lg-6 content-lg-right">
                    <button type="button" class="btn btn-secondary btn-icon editOrderFollowUp" data-followupid="0">
                        <span><i class="fas fa-clipboard-list"></i></span>
                        <span>Wiedervorlage erstellen</span></button>
                </div>
                <div class="col-12">
                    <div class="row no-gutters listHeader">
                        <div class="col-3">
                            Nutzer
                        </div>
                        <div class="col-3">
                            Fällig
                        </div>
                        <div class="col-4">
                            Notiz
                        </div>
                        <div class="col-2">
                            Aktionen
                        </div>


                    </div>
                </div>
                <div class="col-12">

                    <div id="followUps">
                        @if(count($orderFollowUps) > 0)
                            @php $i = 0; @endphp
                            @foreach($orderFollowUps as $orderFollowUp)
                                @if($i >= 5)
                                    <div class="collapse hiddenFollowUps"> @endif
                                        <div class="row no-gutters listItem" data-followupid="{{ $orderFollowUp->id }}">
                                            <div class="col-3">
                                                {{ $orderFollowUp->operator->getName() }}
                                            </div>
                                            <div class="col-3">
                                                {{ $orderFollowUp->nextUp() }}
                                            </div>
                                            <div class="col-4">
                                                {{ $orderFollowUp->note }}
                                            </div>


                                            <div class="col-2">
                                                <div class="row no-gutters align-items-center actions">
                                                    <div class="">
                                                        <a class="editOrderFollowUp cursorPointer"
                                                           data-followupid="{{ $orderFollowUp->id }}"
                                                        ><i class="fal fa-pencil-alt"></i></a>
                                                    </div>
                                                    <div class="">
                                                        <a class="deleteOrderFollowUp cursorPointer"
                                                           data-followupid="{{ $orderFollowUp->id }}"
                                                        ><i class="fal fa-check-circle"></i></a>
                                                    </div>
                                                </div>

                                            </div>

                                        </div>
                                        @if($i >= 5) </div> @endif

                                @php $i++; @endphp
                            @endforeach
                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Noch keine Einträge vorhanden.
                                </div>
                            </div>
                        @endif
                    </div>
                    @if(count($orderFollowUps) > 5)
                        <button class="btn btn-secondary btn-icon showMoreEntries"
                                id="showMoreFollowUps"
                                type="button"
                                data-status="less"
                                data-toggle="collapse"
                                data-target=".hiddenFollowUps"
                                aria-expanded="false">
                            <span><i class="fas fa-clipboard-list"></i></span>
                            <span class="buttonText">Mehr anzeigen</span></button>
                    @endif
                </div>
            </div>
            <div class="row divider-horizontal">&nbsp;</div>
            <div class="row">&nbsp;</div>
        @endif

        <div class="row no-gutters listHeader">
            <div class="col-12">Grunddaten</div>
        </div>

        @if(!UserController::checkRight("hideSensibleOrderData", $user))
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label for="customer_id" class="col-12 col-form-label"><h5>Auftraggeber</h5></label>
                        <div class="col-12">
                            <div class="customerList">
                                <div class="row customerListControls">
                                    <div class="col-6">
                                        <div class="searchCustomer">
                                            <input type="text" class="slide-input search" id="searchFor"
                                                   autocomplete="off"
                                                   data-shownosearchresults="noOrderEditCustomers">
                                        </div>
                                    </div>
                                    <div class="col-6 text-right">
                                        @if(UserController::checkRight("createCustomers", $user))
                                            <label for="plusButton" title="Auftraggeber hinzufügen"
                                                   id="createNewCustomer">
                                                <i class="fas fa-plus-circle"></i></label>
                                        @endif
                                    </div>
                                </div>
                                <div id="customerList">
                                    {{-- Bisheriger Auftraggeber --}}
                                    <div class="customerItem"
                                         data-search-for="{{ $orderToEdit->customer->company }}">
                                        <label class="radio">
                                            {{ $orderToEdit->customer->company }}@if($orderToEdit->customer->place != ""), {{ $orderToEdit->customer->place }}@endif
                                            <input type="radio" name="customer_id"
                                                   value="{{ $orderToEdit->customer->id }}"
                                                   checked="checked">
                                            <div class="indicator"></div>
                                        </label>
                                    </div>
                                    {{-- Weitere Auftraggeber anzeigen --}}
                                    @foreach($customerList as $customer)
                                        @if($customer->id == $orderToEdit->customer_id)
                                            @continue
                                        @endif
                                        <div class="customerItem searchItem"
                                             data-search-for="{{ $customer->company }}">
                                            <label class="radio">
                                                {{ $customer->company }}@if($customer->place != ""), {{ $customer->place }}@endif

                                                <input type="radio" name="customer_id" value="{{ $customer->id }}">
                                                <div class="indicator"></div>
                                            </label>
                                        </div>
                                    @endforeach
                                </div>

                                <div data-nosearchresults="noOrderEditCustomers">Für diese Sucheingabe gibt es leider keine Ergebnisse.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-12 {{ (UserController::checkRight("hideSensibleOrderData", $user))? "" : "col-lg-6"  }}">
                <div class="row">
                    <div class="{{ (UserController::checkRight("hideSensibleOrderData", $user))? "col-6" : "col-12"  }}">
                        <div class="form-group">
                            <label for="order_type_id" class="col-12 col-form-label"><h5>Auftragstyp</h5></label>
                            <div class="col-12">
                                <select class="form-control" id="order_type_id" name="order_type_id"
                                        @if(UserController::checkRight("hideSensibleOrderData", $user))
                                        disabled
                                        @endif
                                >
                                    <option value="" disabled selected>Bitte auswählen</option>
                                    @foreach($orderTypesList as $orderType)
                                        <option value="{{ $orderType->id }}"
                                                data-orderstatus="{{ $orderType->order_statuses->id }}"
                                                @if($orderType->id == $orderToEdit->order_type_id)
                                                selected
                                                @endif
                                        >{{ $orderType->label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    @if(!UserController::checkRight("hideSensibleOrderData", $user))
                </div>
                @endif
                @if(!UserController::checkRight("hideSensibleOrderData", $user))
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="order_status_id" class="col-12 col-form-label"><h5>Auftragsstatus</h5>
                                </label>
                                <div class="col-12">
                                    <select class="form-control" id="order_status_id" name="order_status_id">
                                        @foreach($orderStatusList as $orderStatus)
                                            <option value="{{ $orderStatus->id }}"
                                                    @if($orderStatus->id == $orderToEdit->order_status_id)
                                                    selected
                                                    @endif
                                            >{{ $orderStatus->label }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif


                @if(UserController::checkRight("hideSensibleOrderData", $user))
                    @php $disableResponsibleSelect = "disabled"; @endphp
                @else
                    @php $disableResponsibleSelect = ""; @endphp
                @endif
                @if(!UserController::checkRight("hideSensibleOrderData", $user))
                    <div class="row ">
                        @endif
                        <div class="{{ (UserController::checkRight("hideSensibleOrderData", $user))? "col-6" : "col-12"  }}">
                            <div class="form-group">
                                <label for="responsible_operator_id" class="col-12 col-form-label"><h5>Verantwortliche
                                        Bearbeiter</h5>
                                </label>
                                <div class="col-12">
                                    <div class="inlineList">
                                        {{-- bereits zugewiesene Bearbeiter --}}
                                        @foreach($responsibleOperatorsList as $responsibleOperator)
                                            <div class="inlineListValue"
                                                 data-operatorid="{{ $responsibleOperator->id }}">
                                                <div>
                                                    <label class="checkbox">{{ $responsibleOperator->getName() }}
                                                        <input type="checkbox"
                                                               checked="checked"
                                                               name="responsibleOperators[{{ $responsibleOperator->id }}]"
                                                                {{$disableResponsibleSelect}}
                                                        >
                                                        <span class="checkmark"></span>
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                        {{-- Weitere Bearbeiter --}}
                                        @if(!UserController::checkRight("hideSensibleOrderData", $user))
                                            @foreach($operatorsList as $operator)
                                                <div class="inlineListValue" data-operatorid="{{ $operator->id }}">
                                                    <div>
                                                        <label class="checkbox">{{ $operator->getName() }}
                                                            <input type="checkbox"
                                                                   name="responsibleOperators[{{ $operator->id }}]"
                                                            >
                                                            <span class="checkmark"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
            </div>

            @if(!UserController::checkRight("hideSensibleOrderData", $user))
                <div class="col-12 col-lg-6 orderTagsContainer">
                    <div class="form-group">
                        <label for="order_tags" class="col-12 col-form-label"><h5>Auftragskennzeichen</h5></label>
                        <div class="col-12">
                            <div class="orderTagsValueList">


                                <div class="orderTagHeader">
                                    Zugewiesene Kennzeichen
                                </div>
                                @if(count($orderToEdit->order_tags) <= 0)
                                    <div class="orderTagValue noTags">Keine Kennzeichen zugeordnet.</div>
                                @else
                                    <div class="orderTagsList" id="existingOrderTags">
                                        @foreach($orderToEdit->order_tags as $orderTag)
                                            <div class="orderTagValue" data-ordertype="{{ $orderTag->order_types_id }}"
                                                 data-ordertag="{{ $orderTag->id }}">
                                                <div style="display: inline-block;width:49%;">
                                                    <label class="checkbox">{{ $orderTag->label }}
                                                        <input type="checkbox"
                                                               name="ordertags[{{ $orderTag->id }}]"
                                                               checked="checked"
                                                               data-ordertag="{{ $orderTag->id }}"
                                                        >
                                                        <span class="checkmark"></span>
                                                    </label>
                                                </div>
                                                <div style="display: inline-block;width:49%;">
                                                    <input type="text" name="ordertagsValues[{{ $orderTag->id }}]"
                                                           value="{{ $orderTag->pivot->tag_value }}">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif

                                <div class="orderTagHeader newOrderTags">
                                    Neue Kennzeichen
                                </div>

                                <div class="orderTagsList" id="newOrderTags">
                                </div>

                                <div class="orderTagHeader">
                                    Weitere Kennzeichen
                                </div>
                                {{-- Alle Auftragskennzeichen mit Bezug auflisten, um sie danach dynamisch zuweisen zu
                                     können --}}
                                <div class="orderTagsList" id="additionalOrderTags">
                                    @foreach($orderTagsList as $orderTag)
                                        <div class="orderTagValue" data-ordertype="{{ $orderTag->order_types_id }}"
                                             data-ordertag="{{ $orderTag->id }}">
                                            <div style="display: inline-block;width:49%;">
                                                <label class="checkbox">{{ $orderTag->label }}
                                                    <input type="checkbox"
                                                           name="ordertags[{{ $orderTag->id }}]"
                                                           data-ordertag="{{ $orderTag->id }}"
                                                    >
                                                    <span class="checkmark"></span>
                                                </label>
                                            </div>
                                            <div style="display: inline-block;width:49%;">
                                                <input type="text" name="ordertagsValues[{{ $orderTag->id }}]">
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="orderTagsChanged" id="orderTagsChanged" value="0">
                </div>
            @else
                {{--Sonderdarstellung der Kennzeichen für Subunternehmer bzw. User mit dem Recht, sensible Daten nicht einsehen zu können--}}
                <div class="col-12 col-lg-6 orderTagsContainer">
                    <div class="form-group">
                        <label for="order_tags" class="col-12 col-form-label"><h5>Auftragskennzeichen</h5></label>
                        <div class="col-12">
                            <div class="orderTagsValueList">

                                <div class="orderTagHeader">
                                    Zugewiesene Kennzeichen
                                </div>
                                @if(count($orderToEdit->order_tags) <= 0)
                                    <div class="orderTagValue noTags">Keine Kennzeichen zugeordnet.</div>
                                @else
                                    <div class="orderTagsList" id="existingOrderTags">
                                        @foreach($orderToEdit->order_tags as $orderTag)
                                            <div class="orderTagValue" data-ordertype="{{ $orderTag->order_types_id }}"
                                                 data-ordertag="{{ $orderTag->id }}">
                                                <div style="display: inline-block;width:49%;">
                                                    {{ $orderTag->label }}
                                                </div>
                                                <div style="display: inline-block;width:49%;">
                                                    <input type="text" readonly name="ordertagsValues[{{ $orderTag->id }}]"
                                                           value="{{ $orderTag->pivot->tag_value }}">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

            @endif
        </div>

        <div class="col-12">
            <div class="form-group">
                <label for="description_text" class="col-12 col-form-label"><h5>Auftragsbeschreibung</h5>
                </label>
                <div class="col-12">
                  <textarea class="form-control"
                            style="height:300px;"
                            name="description_text"
                            id="description_text">{{ $orderToEdit->description }}</textarea><br/>
                </div>
            </div>
        </div>

        @if(!UserController::checkRight("hideSensibleOrderData", $user))
            <div class="row no-gutters listHeader">
                <div class="col-12">Abrechnung</div>
            </div>

            <div class="row">
                <div class="col-12 col-lg-6">
                    <div class="form-group">
                        <label for="order_payment_status_id" class="col-12 col-form-label"><h5>Bezahlstatus</h5>
                        </label>
                        <div class="col-12">
                            <select class="form-control" id="order_payment_status_id"
                                    name="order_payment_status_id">
                                @foreach($orderPaymentStatusList as $orderPaymentStatus)
                                    <option value="{{ $orderPaymentStatus->id }}"
                                            @if($orderPaymentStatus->id == $orderToEdit->order_payment_status_id)
                                            selected
                                            @endif
                                    >{{ $orderPaymentStatus->label }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                </div>
                <div class="col-12 col-lg-3">
                    <div class="form-group">
                        <label for="order_value" class="col-12 col-form-label"><h5>Auftragswert (EUR)</h5>
                        </label>
                        <div class="col-12">
                            <input type="text" class="form-control" name="order_value" id="order_value"
                                   value="{{ $orderToEdit->getOrderValueDisplay() }}">
                        </div>
                    </div>
                </div>
                <div class="col-12 col-lg-3">
                    <div class="form-group">
                        <label for="apartment_units" class="col-12 col-form-label"><h5>Wohneinheiten</h5>
                        </label>
                        <div class="col-12">
                            <input type="number" class="form-control" name="apartment_units" id="apartment_units"
                                   value="{{ $orderToEdit->apartment_units }}">
                        </div>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-12 col-lg-6">
                    <div class="form-group">
                        <label for="export_date" class="col-12 col-form-label"><h5>Exporttermin</h5>
                        </label>
                        <div class="col-12">
                            <input type="date" class="form-control" name="export_date" id="export_date"
                                   value="{{ $orderToEdit->getExportDateDateString() }}" max="9999-12-31">
                        </div>
                    </div>
                </div>
                <div class="col-12 col-lg-6">
                    <div class="form-group">
                        <label for="order_value" class="col-12 col-form-label"><h5>Endtermin</h5>
                        </label>
                        <div class="col-12">
                            <input type="date" class="form-control" name="end_date" id="end_date"
                                   value="{{ $orderToEdit->getEndDateDateString() }}" max="9999-12-31">
                        </div>
                    </div>
                </div>
            </div>

            <div class="row divider-horizontal">&nbsp;</div>
            <div class="row">&nbsp;</div>

            <a href="/" id="order_invoices"></a>

            <div class="row" data-itable='1'>
                <div class="col-12 col-lg-6"><h3>Rechnungen</h3></div>
                <div class="col-12 col-lg-6 content-lg-right">
                    <button type="button" class="btn btn-secondary btn-icon" id="addInvoiceEntry">
                        <span><i class="fas fa-clipboard-list"></i></span>
                        <span>Rechnung erstellen</span></button>
                </div>
                <div class="col-12">
                    <div class="row no-gutters listHeader">
                        <div class="col-3">
                            Auftragsnummer
                        </div>
                        <div class="col-3 text-right">
                            Auftragswert
                        </div>
                        <div class="col-2 text-center">
                            Datum
                        </div>
                        <div class="col-2 text-center">
                            PDF
                        </div>
                        <div class="col-2 text-center">
                            Druck
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div id="invoiceEntries">
                        @if(count($orderInvoices) > 0)
                            @foreach($orderInvoices as $orderInvoice)
                                <div class="row no-gutters listItem">
                                    <div class="col-3">
                                        {{ $orderInvoice["invoice_number"] }}
                                    </div>
                                    <div class="col-3 text-right">
                                        {{ $orderInvoice["total_price"] }}
                                    </div>
                                    <div class="col-2 text-center">
                                        {{ $orderInvoice["date_of_issue"] }}
                                    </div>
                                    <div class="col-2 text-center">
                                        <a href="/order_invoice/pdf/{{ $orderInvoice["id"] }}"><i
                                                    class="fal fa-file-pdf"></i></a>
                                    </div>
                                    <div class="col-2 text-center">
                                        <a href="/order_invoice/pdf/print/{{ $orderInvoice["id"] }}"><i
                                                    class="fal fa-file-pdf"></i></a>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Noch keine Einträge vorhanden.
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        <div class="row no-gutters mt-5" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-10">
                        Adressen
                    </div>
                    <div class="col-1 offset-1">
                        Aktionen
                    </div>
                </div>

                <?php
                    if(count($orderToEdit->addresses) > 0)
                    {
                        $searchMapString = "";
                        foreach($orderToEdit->addresses as $orderAddress)
                        {
                            $searchMapString = $orderAddress->street . " " . $orderAddress->house_number;
                            $searchMapString.= "," . $orderAddress->zipcode . " " . $orderAddress->place;
                            $searchMapString = urlencode($searchMapString);
                            ?>
                            <div class="row">
                                <div class="col-12">

                                    <iframe id="themap" src="https://maps.google.com/maps?q=<?=$searchMapString?>&amp;iwloc=near&amp;output=embed&amp;z=17" width="100%" height="500px" frameborder="0" style="margin-top:10px;border:5px solid #282d67;" class="scrolloff"></iframe>

                                </div>
                            </div>
                            <?php
                            break;
                        }
                    }

                ?>

                <div class="row align-items-center">
                    <div class="col-12">
                        <button type="button" class="btn btn-secondary btn-icon" id="addAddress">
                            <span><i class="fas fa-home"></i></span>
                            <span>Adresse hinzufügen</span></button>
                    </div>
                </div>

                <div id="addressListItems">
                    @if(count($orderToEdit->addresses) > 0)
                        @foreach($orderToEdit->addresses as $orderAddress)
                            <div class="row no-gutters listItem"
                                 data-addressindex="{{ $orderAddress->id }}"
                                 data-addressexisted="true">
                                <div class="col-10">
                                    <div class="row">
                                        <div class="col-1">
                                            <i class="fas fa-home"></i>
                                        </div>
                                        <div class="col-4">
                                            <div class="row no-gutters">
                                                <strong>Anschrift</strong>
                                            </div>
                                            <div class="row no-gutters">
                                                {{ $orderAddress->street }} {{ $orderAddress->house_number }}
                                            </div>
                                            <div class="row no-gutters">
                                                @if($orderAddress->address_addendum <> "")
                                                    {{ $orderAddress->address_addendum }}
                                                @endif
                                            </div>
                                            <div class="row no-gutters">

                                                {{ $orderAddress->zipcode }} {{ $orderAddress->place }}
                                            </div>
                                            <div class="row no-gutters">
                                                {{ $orderAddress->country }}
                                            </div>
                                        </div>

                                        <div class="col-4">
                                            <div class="row no-gutters">
                                                <strong>Ansprechpartner</strong>
                                            </div>
                                            <div class="row no-gutters">
                                                @if($orderAddress->company <> "")
                                                    {{ $orderAddress->company }}
                                                @endif
                                            </div>
                                            <div class="row no-gutters">
                                                {{ $orderAddress->name }} {{ $orderAddress->firstname }}
                                            </div>
                                            <div class="row no-gutters">
                                                <strong>Kontakt</strong>
                                            </div>
                                            <div class="row no-gutters">
                                                Tel.: {{ $orderAddress->telephone_number }}
                                            </div>
                                            <div class="row no-gutters">
                                                E-Mail: {{ $orderAddress->email_final_customer }}
                                            </div>
                                        </div>

                                        <div class="col-3">
                                            <div class="row no-gutters">
                                                <strong>Zusätzliche Notiz</strong>
                                            </div>

                                            <div class="row no-gutters">
                                                {{ $orderAddress->note }}
                                            </div>
                                        </div>
                                    </div>


                                </div>

                                <div class="col-2">
                                    <div class="row actions">
                                        <div class="">
                                            <a data-addressindex="{{ $orderAddress->id }}"
                                               data-addressExisted="true"
                                               class="editAddress cursorPointer"
                                               title="Bearbeiten">
                                                <i class="fas fa-pencil-alt"></i>
                                            </a>
                                        </div>
                                        <div class="">
                                            <a data-addressindex="{{ $orderAddress->id }}"
                                               data-addressExisted="true"
                                               class="deleteAddress cursorPointer"
                                               title="Bearbeiten">
                                                <i class="fas fa-trash-alt"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div id="noListEntries" class="row">
                            <div class="col-12 text-center">
                                Noch keine Adressen zum Auftrag hinterlegt.
                            </div>
                        </div>
                    @endif
                </div>

            </div>
        </div>

        <div id="addressInputsHidden">
            {{-- Bereits bestehende Adressen lesen --}}
            @foreach($orderAddresses as $orderAddressId => $orderAddress)

                <input type="hidden"
                       data-addressindex="{{ $orderAddressId }}"
                       name="address[{{ $orderAddressId }}]"
                       value="{{ $orderAddress }}">

            @endforeach
        </div>


        <div class="row divider-horizontal">&nbsp;</div>
        <div class="row">&nbsp;</div>

        @if(!UserController::checkRight("hideSensibleOrderData", $user))

            <div class="row" data-itable='1'>
                <div class="col-12 col-lg-6"><h3>Gutschriften</h3></div>
                <div class="col-12 col-lg-6 content-lg-right">
                    <button type="button" class="btn btn-secondary btn-icon" id="addCreditNote">
                        <span><i class="fas fa-euro-sign"></i></span>
                        <span>Gutschrift hinzufügen</span></button>
                </div>
                <div class="col-12">
                    <div class="row no-gutters listHeader">
                        <div class="col-1">
                            Eingangsd.
                        </div>
                        <div class="col-2 text-right">
                            E-Verg.
                        </div>
                        <div class="col-2 text-right">
                            Gutschriftnr.
                        </div>
                        <div class="col-2 text-right">
                            Avis
                        </div>
                        <div class="col-2 text-right">
                            Wert
                        </div>
                        <div class="col-2 text-right">
                            Abschlussd.
                        </div>
                        <div class="col-1 text-right">
                            Aktionen
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div id="creditNoteEntries">
                        @php $i = 0; @endphp

                        @if(count($orderToEdit->creditNotes) > 0)
                            @foreach($orderToEdit->creditNotes as $orderCreditNote)

                                @if($i >= 5)
                                    <div class="collapse hiddenCreditNotes">
                                        @endif
                                        <div class="row no-gutters listItem"
                                             data-creditnoteindex="{{ $orderCreditNote->id }}"
                                             data-creditnoteexisted="true">
                                            <div class="col-1">
                                                {{ $orderCreditNote->getReadableDate() }}
                                            </div>
                                            <div class="col-2 text-right">
                                                {{ $orderCreditNote->fetch_number }}
                                            </div>
                                            <div class="col-2 text-right">
                                                {{ $orderCreditNote->credit_note_number }}
                                            </div>
                                            <div class="col-2 text-right">
                                                {{ $orderCreditNote->reference_number }}
                                            </div>
                                            <div class="col-2 text-right">
                                                {{ $orderCreditNote->getReadableValue() }} €
                                            </div>
                                            <div class="col-2  text-right">
                                                {{ $orderCreditNote->getReadableEndDate() }}
                                            </div>
                                            <div class="col-1">
                                                <div class="row actions">
                                                    <div class="col-6">
                                                        <a class="editCreditNote cursorPointer"
                                                           data-creditnoteindex="{{ $orderCreditNote->id }}"
                                                           data-creditnoteexisted="true"
                                                        ><i class="fas fa-pencil-alt"></i></a>
                                                    </div>

                                                    <div class="col-6">
                                                        <a class="deleteCreditNote cursorPointer"
                                                           data-creditnoteindex="{{ $orderCreditNote->id }}"
                                                           data-creditnoteexisted="true"
                                                        ><i class="fas fa-trash-alt"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @if($i >= 5) </div> @endif
                                @php $i++; @endphp
                            @endforeach

                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Noch keine Einträge vorhanden.
                                </div>
                            </div>
                        @endif
                        @if(count($orderCreditNotes) > 5)
                            <button class="btn btn-secondary btn-icon showMoreEntries"
                                    id="showMoreCreditNoteEntries"
                                    type="button"
                                    data-status="less"
                                    data-toggle="collapse"
                                    data-target=".hiddenCreditNotes"
                                    aria-expanded="false">
                                <span><i class="fas fa-euro-sign"></i></span>
                                <span class="buttonText">Mehr anzeigen</span></button>
                        @endif

                    </div>
                </div>
            </div>

            <div id="creditNoteInputsHidden">
                {{-- Bereits bestehende Gutschriften lesen --}}
                @foreach($orderCreditNotes as $orderCreditNoteId => $orderCreditNote)
                    <input type="hidden"
                           data-creditnoteindex="{{ $orderCreditNoteId }}"
                           name="creditNote[{{ $orderCreditNoteId }}]"
                           value="{{ $orderCreditNote }}">
                @endforeach
            </div>

            <div class="row divider-horizontal">&nbsp;</div>
            <div class="row">&nbsp;</div>
        @endif

        <div class="row mt-5">
            @if(!UserController::checkRight("hideSensibleOrderData", $user))

                <div class="col-12 col-lg-6" data-itable='1'>
                    <h3>Mitarbeiter- und Terminplanung</h3>

                    {{-- Vorhandene Aufragstermine anzeigen --}}
                    <div class="row no-gutters listHeader">
                        <div class="col-6">Bearbeiter</div>
                        <div class="col-4">Termin</div>
                        <div class="col-2">Aktionen</div>
                    </div>

                    <div id="orderAppointments">
                        @if(count($orderAppointments) > 0)
                            @foreach($orderAppointments as $orderAppointmentID => $orderAppointment)
                                <div class="row no-gutters listItem orderAppointment"
                                     data-appointmentindex="{{ $orderAppointmentID }}">

                                    <div class="col-6">
                                        {{ $orderAppointment["operator"] }}
                                    </div>
                                    <div class="col-4">
                                        {{ $orderAppointment["appointment"] }}
                                    </div>
                                    <div class="col-2">

                                        <div class="row actions">
                                            <div class="">
                                                <a class="sendAppointmentMail cursorPointer"
                                                   data-appointmentindex="{{ $orderAppointmentID }}"
                                                   data-appointmentexisted="true"
                                                ><i class="fas fa-envelope"></i></a>
                                            </div>

                                            <div class="">
                                                <a class="deleteOrderAppointment cursorPointer"
                                                   data-appointmentindex="{{ $orderAppointmentID }}"
                                                   data-appointmentexisted="true"
                                                ><i class="fas fa-trash-alt"></i></a>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            @endforeach
                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Noch keine Termine und Bearbeiter zum Auftrag hinterlegt.
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="col-12 align-items-center">
                        <button type="button" id="openCalendar" class="btn btn-secondary btn-icon">
                            <span><i class="fas fa-calendar-alt"></i></span>
                            <span>Termin erstellen</span></button> &nbsp;
                    </div>

                    <div class="col-12">
                        <div id="appointmentInputsHidden">

                        </div>

                        <input type="hidden" name="appointmentsToDelete" id="appointmentsToDelete"
                               value='{ "appointmentsToDelete": [] }'>

                    </div>
                </div>
            @endif

            <div class="col-12 {{ (UserController::checkRight("hideSensibleOrderData", $user))? "" : "col-lg-6"  }}"
                 data-itable='1'>

                <h3>Auftragsdokumente</h3>

                {{-- Vorhandene Auftragsdokumente anzeigen --}}
                <div class="row no-gutters listHeader">
                    <div class="col-6">Dokument</div>
                    <div class="col-3">Größe</div>
                    <div class="col-3">Aktionen</div>
                </div>

                <div id="orderDocumentEntries">
                    @php $i = 0; @endphp

                    @if(count($orderDocuments) > 0)
                        @foreach($orderDocuments as $orderDocumentId => $orderDocument)
                            @if($i >= 3)
                                <div class="collapse hiddenDocumentEntries">
                                    @endif
                                    {{--Prüfung der Zugriffsrechte auf die Datei--}}
                                    @if(UserController::isSuperAdmin($user) || $orderDocument["user_id"] == $user->id
                                    || ($orderDocument["user_id"]!= 0 && !UserController::checkRight("hideSensibleOrderData", User::find($orderDocument["user_id"])) && $orderDocument["locked"] == 0)
                                    || ($orderDocument["user_id"]== 0 && $orderDocument["locked"] == 0))
                                    <div class="row no-gutters listItem orderDocument"
                                         data-orderdocument="{{ $orderDocumentId }}">

                                        <div class="col-1">
                                            <img src="{{ $orderDocument["icon"] }}">
                                        </div>
                                        <div class="col-5">{{ $orderDocument["name"] }}
                                            ({{ $orderDocument["mimetypeLabel"] }})
                                        </div>
                                        <div class="col-3">
                                            {{ $orderDocument["size"] }} {{ $orderDocument["sizeUnit"] }}
                                        </div>
                                        <div class="col-3">
                                            <div class="row actions">
                                                <div class="">
                                                    @if($orderDocument["mimetypeLabel"]  == "PDF" ||
                                                        $orderDocument["mimetypeLabel"]  == "Bild" )
                                                        <a href="{{ $orderDocument["url"] }}"
                                                           target="_blank"
                                                           class="openOrderDocument"
                                                           data-orderdocument="{{ $orderDocumentId }}"
                                                        ><i class="fas fa-eye"></i></a>
                                                    @endif
                                                </div>
                                                <div class="">
                                                    <a href="{{ route('download.orderDocument', ["orderDocumentId" => $orderDocumentId]) }}"
                                                       target="_blank"
                                                       class="downloadOrderDocument"
                                                    ><i class="fas fa-download"></i></a>
                                                </div>
                                                <div class="">
                                                    <a class="deleteOrderDocument"
                                                       data-orderdocument="{{ $orderDocumentId }}"
                                                    ><i class="fas fa-trash-alt"></i></a>
                                                </div>
                                                {{-- Schützen/Entsperren eines Dokuments --}}
                                                @if (UserController::isSuperAdmin($user))
                                                    <div class="">
                                                        <a class="lockunlockOrderDocument specialtogglelock"
                                                           data-orderdocument="{{ $orderDocumentId }}"
                                                        >
                                                            @if ($orderDocument["locked"] == 1)
                                                                <i class="fas fa-lock-alt"></i>
                                                            @else
                                                                <i class="fas fa-lock-open-alt"></i>
                                                            @endif
                                                        </a>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                        @php $i++; @endphp
                                    @endif
                                    @if($i >= 4) </div> @endif
                        @endforeach
                    @else
                        <div id="noListEntries" class="row">
                            <div class="col-12 text-center">
                                Noch keine Dokumente zum Auftrag hinterlegt.
                            </div>
                        </div>
                    @endif
                    @if(count($orderDocuments) > 3)
                        <button class="btn btn-secondary btn-icon showMoreEntries"
                                id="showMoreDocumentEntries"
                                type="button"
                                data-status="less"
                                data-toggle="collapse"
                                data-target=".hiddenDocumentEntries"
                                aria-expanded="false">
                            <span><i class="fas fa-file"></i></span>
                            <span class="buttonText">Mehr anzeigen</span></button>
                    @endif

                </div>
                {{-- Liste für die via Dropzone hochgeladenen Files --}}
                <input type="hidden" id="newFiles" name="newFiles" value='{ "files": [] }'>

                {{-- Liste für die zu löschenden Dokumente--}}
                <input type="hidden" name="documentsToDelete" id="documentsToDelete" value='{ "documents": [] }'>

                {{-- Liste für hinzuzufügende, vom Bearbeiter verfasste Logs --}}
                <input type="hidden" id="newLogEntries" name="newLogEntries" value='{ "logs": [] }'>
                {!! BootForm::close() !!}

                <div class="col-12 p-0 mt-5">
                    <?php
                    echo $orderDocumentsDropzone->getDropzoneForm();
                    ?>
                </div>

            </div>
        </div>

        <div class="row divider-horizontal">&nbsp;</div>
        <div class="row">&nbsp;</div>

        @if(!UserController::checkRight("hideSensibleOrderData", $user))

            <div class="row" data-itable='1'>
                <div class="col-12 col-lg-6"><h3>E-Mail-Historie</h3></div>
                <div class="col-12 col-lg-6 content-lg-right">
                    <button type="button" class="btn btn-secondary btn-icon" id="addOrderMail">
                        <span><i class="fas fa-envelope"></i></span>
                        <span>E-Mail erstellen</span></button>
                </div>
                <div class="col-12">
                    <div class="row no-gutters listHeader">
                        <div class="col-3">
                            Betreff
                        </div>
                        <div class="col-5">
                            Nachricht
                        </div>
                        <div class="col-2">
                            Nutzer
                        </div>
                        <div class="col-2">
                            Versendet
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div id="mailEntries">
                        @php $i = 0; @endphp

                        @if(count($orderMailLogs) > 0)
                            @foreach($orderMailLogs as $orderMailLog)

                                @if($i >= 5)
                                    <div class="collapse hiddenMailEntries">
                                        @endif
                                        <div class="row no-gutters listItem">
                                            <div class="col-3" style="word-break: break-word; padding-right: 10px;">
                                                <div class="row no-gutters label">
                                                    {{ $orderMailLog->subject }}<br>
                                                </div>
                                                <div class="row no-gutters">
                                                    {{ $orderMailLog->to }}
                                                </div>
                                            </div>
                                            <div class="col-5" style="word-break: break-word; padding-right: 10px;">
                                                {{ $orderMailLog->messageExcerpt(150) }}
                                            </div>
                                            <div class="col-2">
                                                {{ $orderMailLog->operator->name }} {{ $orderMailLog->operator->firstname }}
                                            </div>
                                            <div class="col-2">
                                                @if($orderMailLog->error == false)
                                                    @if($orderMailLog->sent == true)
                                                        {{ $orderMailLog->sentDate() }}
                                                    @else
                                                        demnächst
                                                    @endif
                                                @else
                                                    <strong>Senden fehlgeschlagen</strong>
                                                @endif
                                            </div>
                                        </div>
                                        @if($i >= 5) </div> @endif
                                @php $i++; @endphp
                            @endforeach

                        @else
                            <div id="noListEntries" class="row">
                                <div class="col-12 text-center">
                                    Noch keine Einträge vorhanden.
                                </div>
                            </div>
                        @endif
                        @if(count($orderMailLogs) > 5)
                            <button class="btn btn-secondary btn-icon showMoreEntries"
                                    id="showMoreMailEntries"
                                    type="button"
                                    data-status="less"
                                    data-toggle="collapse"
                                    data-target=".hiddenMailEntries"
                                    aria-expanded="false">
                                <span><i class="fas fa-envelope"></i></span>
                                <span class="buttonText">Mehr anzeigen</span></button>
                        @endif

                    </div>
                </div>
            </div>


            <div class="row divider-horizontal">&nbsp;</div>
            <div class="row">&nbsp;</div>
        @endif

        <div class="row" data-itable='1'>
            <div class="col-12 col-lg-6"><h3>Auftragshistorie</h3></div>
            <div class="col-12 col-lg-6 content-lg-right">
                <button type="button" class="btn btn-secondary btn-icon" id="addLogEntry">
                    <span><i class="fas fa-clipboard-list"></i></span>
                    <span>Eintrag erstellen</span></button>
            </div>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-9">
                        Eintrag
                    </div>
                    <div class="col-2">
                        Nutzer
                    </div>
                    <div class="col-1">
                        Datum
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div id="logEntries">

                    @if(count($orderLogs) > 0)
                        @php $i = 0; @endphp
                        @foreach($orderLogs as $orderLog)
                            @if($i >= 5)
                                <div class="collapse hiddenEntries"> @endif
                                    <div class="row no-gutters listItem {{ $orderLog["class"] }}">
                                        <div class="col-9">
                                            {{ $orderLog["text"] }}
                                        </div>
                                        <div class="col-2">
                                            {{ $orderLog["creator"] }}
                                        </div>
                                        <div class="col-1">
                                            {{ $orderLog["created"] }}
                                        </div>
                                    </div>
                                    @if($i >= 5) </div> @endif

                            @php $i++; @endphp

                        @endforeach
                    @else
                        <div id="noListEntries" class="row">
                            <div class="col-12 text-center">
                                Noch keine Einträge vorhanden.
                            </div>
                        </div>
                    @endif
                    @if(count($orderLogs) > 5)
                        <button class="btn btn-secondary btn-icon showMoreEntries"
                                id="showMoreLogEntries"
                                type="button"
                                data-status="less"
                                data-toggle="collapse"
                                data-target=".hiddenEntries"
                                aria-expanded="false">
                            <span><i class="fas fa-clipboard-list"></i></span>
                            <span class="buttonText">Mehr anzeigen</span></button>
                    @endif
                </div>
            </div>
        </div>


        <div class="row mt-5">
            <div class="col-12 col-lg-6 mt-5 text-lg-left">
                @if(!UserController::checkRight("hideSensibleOrderData", $user))
                    <a class="button-secondary-big"
                       href="{{ route('orders.datasheet', ['orderId' => $orderToEdit->id]) }}"
                       style="">
                        Datenblatt erzeugen
                    </a>
                @endif

            </div>

            <div class="col-12 col-lg-6 mt-5 text-lg-right">
                <button type="button" class="btn btn-primary btn-big additionalOrderSubmit">
                    Auftrag speichern
                </button>
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <?php
    echo $orderDocumentsDropzone->getDropzoneJSCode();
    ?>
    <script>
        jQuery(document).ready(function () {
            // Modifizierung der Auftragskennzeichen: Klick auf bereits zugewiesenes Kennzeichen
            jQuery(document).on('click', '#existingOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Input-Feld leeren und Kennzeichen in "Weitere Kennzeichen" verschieben
                jQuery("#existingOrderTags .orderTagValue[data-ordertag=" + orderTagId + "] input[type=text]").val("");
                jQuery("#existingOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#additionalOrderTags");

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Modifizierung der Auftragskennzeichen: Klick auf neues Kennzeichen
            jQuery(document).on('click', '#additionalOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Kennzeichen in "Neue Kennzeichen" verschieben
                jQuery("#additionalOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#newOrderTags");

                jQuery("#newOrderTags").fadeIn();
                jQuery(".orderTagHeader.newOrderTags").fadeIn();

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Modifizierung der Auftragskennzeichen: Klick auf neu hinzugefügtes Kennzeichen
            jQuery(document).on('click', '#newOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Input-Feld leeren und Kennzeichen in "Weitere Kennzeichen" verschieben
                jQuery("#newOrderTags .orderTagValue[data-ordertag=" + orderTagId + "] input[type=text]").val("");
                jQuery("#newOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#additionalOrderTags");

                // Wenn keine neu hinzugefügten Kennzeichen mehr da sind, Header ausblenden
                if (jQuery("#newOrderTags > *").length <= 0) {
                    jQuery(".orderTagHeader.newOrderTags").fadeOut();
                }

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Beim Tippen in ein Auftragskennzeichenwertefeld  // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
            jQuery("input[name^=ordertagsValues]").change(function () {
                jQuery("input#orderTagsChanged").val("1");
            });

            // Neuen Auftraggeber anlegen
            jQuery("#createNewCustomer").click(function () {
                showLoadingSpinner();
                let url = "/customer";
                let customer_id = 0;

                $.get(url + '/' + customer_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });

            });

            // Adresse hinzufügen
            jQuery("#addAddress").click(function () {
                showLoadingSpinner();
                let url = "/orders/new/addAddress";
                let address_id = 0;

                $.get(url + '/' + address_id, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

            // Kalender öffnen um Termin auszuwählen
            jQuery("#openCalendar").click(function () {
                showLoadingSpinner();
                let url = "/operator/calendar/summarylayer";

                // Request new Calendar
                jQuery.ajax({
                    method: 'GET',
                    url: url,
                    data: {
                        'callback': 'setAppointmentFromCalendarLayer'
                    },
                    success: function (data) {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                        specialResize();
                    },
                    error: function () {
                        showModalBox("Es ist ein Fehler aufgetreten.", "");
                        hideLoadingSpinner();
                    }
                });
            });

            // Logeintrag hinzufügen: Layer öffnen
            jQuery("#addLogEntry").click(function () {
                showLoadingSpinner();
                let orderId = jQuery("input[name=orderToEdit]").val();
                let url = "/order/" + orderId + "/log/new";

                $.get(url, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });

            // Rechnung erstellen: Layer öffnen
            jQuery("#addInvoiceEntry").click(function () {
                showLoadingSpinner();
                let orderId = jQuery("input[name=orderToEdit]").val();
                let url = "/order_invoice/new/" + orderId;

                $.get(url, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", "");
                    }
                });
            });

            // Auftragsmail versenden: Layer öffnen
            jQuery("#addOrderMail").click(function () {
                showLoadingSpinner();
                let orderId = jQuery("input[name=orderToEdit]").val();
                let url = "/ordermail/new/" + orderId;

                $.get(url, function (data) {

                    if (data.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowWide");
                        jQuery("#listEditor").fadeIn();
                    } else {
                        showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                        hideLoadingSpinner();
                    }
                });
            });
        });

        // Adresseingaben verarbeiten
        jQuery(document).on('click', 'button#editOrderAddress', function () {

            // Eingabe validieren
            if (!jQuery("form#editOrderAddress").valid()) {
                showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
                return;
            }

            // Editierkennzeichen lesen
            let edit = jQuery("input#addressEdit").val();

            // Daten für eine neue Adresse aus dem Overlay holen und als JSON-Objekt speichern
            let newAddress = {};

            newAddress.name = jQuery("input#address_name").val();
            newAddress.firstname = jQuery("input#address_firstname").val();
            newAddress.company = jQuery("input#address_company").val();
            newAddress.street = jQuery("input#address_street").val();
            newAddress.house_number = jQuery("input#address_house_number").val();
            newAddress.address_addendum = jQuery("input#address_address_addendum").val();
            newAddress.zipcode = jQuery("input#address_zipcode").val();
            newAddress.place = jQuery("input#address_place").val();
            newAddress.country = jQuery("input#address_country").val();
            newAddress.telephone_number = jQuery("input#address_telephone_number").val();
            newAddress.note = jQuery("textarea#address_note").val();
            newAddress.email_final_customer = jQuery("input#address_email_final_customer").val();

            if (jQuery("input#addressExisted").val() == "true")
                newAddress.addressExisted = true;
            else
                newAddress.addressExisted = false;

            let jsonString = JSON.stringify(newAddress);


            let newIndex = 0;

            if (edit === "true") {
                let addressID = jQuery("input#addressID").val();

                // Bestehendes Input mit dieser Adress-ID löschen
                jQuery("input[data-addressindex='" + addressID + "']").remove();

                // Listeneintrag löschen
                jQuery("div.listItem[data-addressindex='" + addressID + "']").remove();

                newIndex = addressID;
            } else {
                // Letzten Adressindex finden
                let i = 0;

                jQuery("#addressInputsHidden > input[data-addressindex]").each(function () {
                    if (i <= jQuery(this).data("addressindex")) {
                        i = jQuery(this).data("addressindex");
                    }
                });

                // Neuen Index bestimmen
                newIndex = i + 1;
            }

            let newAddressInput = "<input type='hidden' data-addressindex='" + newIndex + "' " +
                "                         name='address[" + newIndex + "]' value='" + jsonString + "'>";

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("#addressInputsHidden").append(newAddressInput);

            // Adressenteaser für Liste bauen
            let addressAddendum = "";
            let company = "";
            if (newAddress.address_addendum != "") addressAddendum = newAddress.address_addendum;
            if (newAddress.company != "") company = newAddress.company;

            // Adresse zur Liste hinzufügen
            let addressItem = '<div class="row no-gutters listItem" data-addressindex="' + newIndex + '">\n' +
                '                                        <div class="col-10">\n' +
                '                                            <div class="row">\n' +
                '                                                <div class="col-1">\n' +
                '                                                    <i class="fas fa-home"></i>\n' +
                '                                                </div>\n' +
                '                                                <div class="col-4">\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Anschrift</strong>\n' +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.street + ' ' + newAddress.house_number +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                addressAddendum +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.zipcode + ' ' + newAddress.place +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.country +
                '                                                    </div>\n' +
                '                                                </div>\n' +
                '\n' +
                '                                                <div class="col-4">\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Ansprechpartner</strong>\n' +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                company +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.name + ' ' + newAddress.firstname +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Kontakt</strong>\n' +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                'Tel.: ' + newAddress.telephone_number +
                '                                                    </div>\n' +
                '                                                    <div class="row no-gutters">\n' +
                'E-Mail: ' + newAddress.email_final_customer +
                '                                                    </div>\n' +
                '                                                </div>\n' +
                '\n' +
                '                                                <div class="col-3">\n' +
                '                                                    <div class="row no-gutters">\n' +
                '                                                        <strong>Zusätzliche Notiz</strong>\n' +
                '                                                    </div>\n' +
                '\n' +
                '                                                    <div class="row no-gutters">\n' +
                newAddress.note +
                '                                                    </div>\n' +
                '                                                </div>\n' +
                '                                            </div>\n' +
                '\n' +
                '\n' +
                '                                        </div>\n' +
                '\n' +
                '                                        <div class="col-1 offset-1 text-right">\n' +
                '                                            <div class="row no-gutters">\n' +
                '                                                <div class="">\n' +
                '                                                    <a href="#"\n' +
                '                                                       data-addressindex="' + newIndex + '"\n' +
                '                                                       data-addressexisted="' + newAddress.addressExisted + '"\n' +
                '                                                       class="editAddress cursorPointer"\n' +
                '                                                       title="Bearbeiten">\n' +
                '                                                        <i class="fal fa-pencil-alt"></i>\n' +
                '                                                    </a>\n' +
                '                                                </div>\n' +
                '<div class="">\n' +
                '                                                    <a data-addressindex="' + newIndex + '"\n' +
                '                                                       data-addressexisted="' + newAddress.addressExisted + '"\n' +
                '                                                       class="deleteAddress cursorPointer"\n' +
                '                                                       title="Bearbeiten">\n' +
                '                                                        <i class="fal fa-trash-alt"></i>\n' +
                '                                                    </a>\n' +
                '                                                </div>' +
                '                                            </div>\n' +
                '                                        </div>\n' +
                '                                    </div>';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#addressListItems #noListEntries").fadeOut();

            jQuery("#addressListItems").append(addressItem);
        });

        // Adresse bearbeiten
        jQuery(document).on('click', '.editAddress', function () {

            let addressID = jQuery(this).data("addressindex");
            let addressExisted = jQuery(this).data("addressexisted");

            showLoadingSpinner();
            let url = "/orders/new/addAddress";
            let address_id = 0;

            $.get(url + '/' + address_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);

                    // Editierkennzeichen, Adressen-ID und Löschfeld setzen
                    jQuery("input#addressEdit").val("true");
                    jQuery("input#addressID").val(addressID);
                    jQuery("button#deleteOrderAddress").data("addressindex", addressID);
                    jQuery("input#addressExisted").val(addressExisted);

                    // Daten aus zugehörigem Input holen
                    let jsonAddressData = jQuery("input[data-addressindex='" + addressID + "']").val();
                    let addressData = JSON.parse(jsonAddressData);

                    // Felder vorbelegen
                    jQuery("input#address_name").val(addressData.name);
                    jQuery("input#address_firstname").val(addressData.firstname);
                    jQuery("input#address_company").val(addressData.company);
                    jQuery("input#address_street").val(addressData.street);
                    jQuery("input#address_house_number").val(addressData.house_number);
                    jQuery("input#address_address_addendum").val(addressData.address_addendum);
                    jQuery("input#address_zipcode").val(addressData.zipcode);
                    jQuery("input#address_place").val(addressData.place);
                    jQuery("input#address_country").val(addressData.country);
                    jQuery("input#address_telephone_number").val(addressData.telephone_number);
                    jQuery("textarea#address_note").val(addressData.note);
                    jQuery("input#address_email_final_customer").val(addressData.email_final_customer);

                    jQuery("#listEditor").addClass("windowWide");
                    jQuery("#listEditor").fadeIn();
                } else {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });

        // Adresse löschen
        jQuery(document).on('click', '.deleteAddress', function () {
            let addressID = jQuery(this).data("addressindex");

            // Input mit dieser Adress-ID auslesen
            let jsonString = jQuery("input[data-addressindex='" + addressID + "']").val();
            let addressData = JSON.parse(jsonString);

            // Löschen-Flag nur setzen, wenn Adresse schon in der Datenbank existiert hat
            if (addressData.addressExisted === true) {
                addressData.deleteAddress = true;

                // Input-Wert aktualisieren
                jsonString = JSON.stringify(addressData);
                jQuery("input[data-addressindex='" + addressID + "']").val(jsonString);
            }
            // Ansonsten Input-Feld einfach löschen
            else {
                jQuery("input[data-addressindex='" + addressID + "']").remove();
            }


            // Listeneintrag wegblenden
            jQuery("div.listItem[data-addressindex='" + addressID + "']").addClass("markAsDeleted");
            jQuery("div.listItem[data-addressindex='" + addressID + "'] a").remove();
            jQuery("div.listItem[data-addressindex='" + addressID + "'] .actions").append("<i class=\"fas fa-minus-circle\"></i>");
            jQuery("#closeListEditor").trigger("click");
        });

        // Auftragsdokument Löschen
        jQuery(document).on('click', 'a.deleteOrderDocument', function () {
            let orderDocumentId = jQuery(this).data("orderdocument");

            // Für Löschen vormerken
            let _documentsToDelete = jQuery("input#documentsToDelete");
            let value_documentsToDelete = _documentsToDelete.val();
            let json_documentsToDelete = JSON.parse(value_documentsToDelete);

            json_documentsToDelete["documents"].push(orderDocumentId);

            let newValue_documentsToDelete = JSON.stringify(json_documentsToDelete);
            _documentsToDelete.val(newValue_documentsToDelete);

            // Als gelöscht anzeigen
            jQuery(".listItem[data-orderdocument=" + orderDocumentId + "]").addClass("markAsDeleted");
            jQuery(".listItem[data-orderdocument=" + orderDocumentId + "] a").remove();
            jQuery(".listItem[data-orderdocument=" + orderDocumentId + "] .actions").append("<i class=\"fas fa-minus-circle\"></i>");
        });


        // Neuen Logeintrag verarbeiten
        jQuery(document).on('click', 'button#addOrderLog', function () {

            // Eingabe validieren
            if (!jQuery("form#addOrderLog").valid()) {
                showModalBox("Validierungsfehler", "")
                return;
            }

            // Daten für einen neuen Log aus dem Overlay holen und im JSON-Objekt speichern
            let newLog = {};
            newLog.operator_id = jQuery("input[name=operatorID]").val();
            newLog.operatorLabel = jQuery("input[name=operatorLabel]").val();
            newLog.order_id = jQuery("input[name=orderID]").val();
            newLog.text = jQuery("textarea#text").val();

            // Bisherige neu hinzugefügte Logs holen
            let jsonLogs = jQuery("input#newLogEntries").val();
            let logs = JSON.parse(jsonLogs);

            logs.logs.push(newLog);

            let newLogs = JSON.stringify(logs);

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("input#newLogEntries").val(newLogs);

            // Neue Log-Nachricht vorblenden
            let newLogListItem = '<div class="row no-gutters listItem userlog">\n' +
                '                            <div class="col-9">\n' +
                newLog.text +
                '                            </div>\n' +
                '                            <div class="col-2">\n' +
                newLog.operatorLabel +
                '                            </div>\n' +
                '                            <div class="col-1">\n' +
                '                                gerade eben \n' +
                '                            </div>\n' +
                '                        </div>';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#logEntries #noListEntries").fadeOut();

            jQuery("#logEntries").prepend(newLogListItem);
        });

        // Neue Auftrags-Email versenden und in Liste vorblenden
        jQuery(document).on('click', 'button#createOrderMail', function () {

            // Daten für eine neue Auftragsmail aus dem Overlay holen
            let newMail = {};
            newMail.operator_id = jQuery("input[name=operatorID]").val();
            newMail.order_id = jQuery("input[name=orderID]").val();
            newMail.to = jQuery("input[name=to]").val();
            newMail.subject = jQuery("input[name=subject]").val();
            newMail.text = jQuery("textarea#text").val();

            // Anhänge bzw. deren Pfade holen
            newMail.attachments = [];
            jQuery("input[data-orderDocumentPath]:checked").each(function () {
                newMail.attachments.push(jQuery(this).data("orderdocumentpath"));
            });

            // Für Vorblendung in Liste
            newMail.operatorLabel = jQuery("input[name=operatorLabel]").val();
            newMail.messageExcerpt = newMail.text.substring(0, 50) + "...";

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/ordermail/send';
            var data = {};
            data["newMail"] = JSON.stringify(newMail);

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {

                    // Erfolgsmeldung anzeigen
                    jQuery("#loadingSpinner").hide();
                    showModalBox("E-Mail erstellt", "Die E-Mail wurde im System  hinterlegt und wird demnächst versendet.");
                    jQuery("#listEditor").removeClass();
                    jQuery("#listOverlay").hide();

                    jQuery("#mailEntries #noListEntries").fadeOut();

                    // E-Mail in Historie vorblenden

                    let newMailLogEntry = ' <div class="row no-gutters listItem">\n' +
                        '                                        <div class="col-3">\n' +
                        '                                           <div class="row no-gutters label">\n' +
                        '                                               ' + newMail.subject + '<br>\n' +
                        '                                           </div>\n' +
                        '                                           <div class="row no-gutters">\n' +
                        '                                               ' + newMail.to + '\n' +
                        '                                           </div>\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-5" style="word-break: break-word; padding-right: 10px;">\n' +
                        '                                            ' + newMail.messageExcerpt + '\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-2">\n' +
                        '                                            ' + newMail.operatorLabel + '\n' +
                        '                                        </div>\n' +
                        '                                        <div class="col-2">\n' +
                        '                                            demnächst \n' +
                        '                                        </div>\n' +
                        '                                    </div>';


                    jQuery("#mailEntries").prepend(newMailLogEntry);
                } else {
                    errorFunction(response);
                }
                hideOverlayLoadingSpinner();
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showOverlayAlert(response.message);

                hideOverlayLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);
        });


        function setAppointmentFromCalendarLayer(data) {
            // Input in DIV für neue Termine hinzufügen
            let appointment = {operatorId: data.operatorid, appointmentDate: data.dateAppointment};

            let i = 0;
            // Letzten Index auslesen
            jQuery("[data-appointmentindex]").each(function () {
                if (i <= jQuery(this).data("appointmentindex")) {
                    i = jQuery(this).data("appointmentindex");
                }
            });

            // Neuen Index bestimmen
            let newIndex = i + 1;

            let newInput = '<input type="hidden" name="newAppointments[' + newIndex + ']" ' +
                '                                data-appointmentindex="' + newIndex + '"\n' +
                '                                value=\'' + JSON.stringify(appointment) + '\'>';


            jQuery("#appointmentInputsHidden").append(newInput);

            // Zeitstempel formatieren
            let appointmentFormatted = formatUNIXTimestampToDate(appointment.appointmentDate);

            // In Liste für Termine vorblenden
            let newListEntry = '<div class="row no-gutters listItem orderAppointment"\n' +
                '                                 data-appointmentindex="' + newIndex + '">\n' +
                '\n' +
                '                                <div class="col-6">\n' +
                '                                    ' + data.operatorName + '\n' +
                '                                </div>\n' +
                '                                <div class="col-4">\n' +
                '                                    ' + appointmentFormatted + '\n' +
                '                                </div>\n' +
                '                                <div class="col-2 text-right">\n' +
                '                                    <a class="deleteOrderAppointment"\n' +
                '                                       data-appointmentindex="' + newIndex + '"\n' +
                '                                       data-appointmentexisted="false"\n' +
                '                                    ><i class="fas fa-trash-alt"></i></a>\n' +
                '                                </div>\n' +
                '\n' +
                '                            </div>';

            jQuery("#orderAppointments").append(newListEntry);

            jQuery("#orderAppointments #noListEntries").fadeOut();

            jQuery("#listEditor").removeClass();
            jQuery("#listOverlay").hide();
        }


        // Auftragstermin löschen
        jQuery(document).on('click', 'a.deleteOrderAppointment', function () {

            let appointmentId = jQuery(this).data("appointmentindex");
            let appointmentExisted = jQuery(this).data("appointmentexisted");

            // Nur zum Löschen vormerken, wenn Termin bereits im System war
            if (appointmentExisted === true) {
                let _deleteAppointments = jQuery("input#appointmentsToDelete");
                let value_deleteAppointments = _deleteAppointments.val();
                let json_deleteAppointments = JSON.parse(value_deleteAppointments);

                json_deleteAppointments["appointmentsToDelete"].push(appointmentId);

                let newValue_deleteAppointments = JSON.stringify(json_deleteAppointments);
                _deleteAppointments.val(newValue_deleteAppointments);
            }
            // Ansonsten Input-Feld löschen
            else {
                jQuery("input[data-appointmentindex='" + appointmentId + "']").remove();
            }

            // In Liste ausblenden
            // Als gelöscht anzeigen
            jQuery("div.listItem[data-appointmentindex='" + appointmentId + "']").addClass("markAsDeleted");
            jQuery("div.listItem[data-appointmentindex='" + appointmentId + "'] a").remove();
            jQuery("div.listItem[data-appointmentindex='" + appointmentId + "'] .actions").append("<i class=\"fas fa-minus-circle\"></i>");
        });

        // Auftragstermin per E-Mail versenden
        jQuery(document).on('click', 'a.sendAppointmentMail', function () {
            showLoadingSpinner();
            let orderId = jQuery("input[name=orderToEdit]").val();
            let appointmentId = jQuery(this).data("appointmentindex");
            let url = "/ordermail/new/" + orderId + "/" + appointmentId;

            $.get(url, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowWide");
                    jQuery("#listEditor").fadeIn();
                } else {
                    showModalBox("Es ist ein Fehler aufgetreten.");
                }
            });
        });


        // Wiedervorlage hinzufügen
        jQuery(document).on('click', '.editOrderFollowUp', function () {
            showLoadingSpinner();

            let followupid = jQuery(this).data("followupid");
            let orderid = jQuery("input[name=orderToEdit]").val();

            let url = "/followups/edit/" + orderid + "/" + followupid;

            $.get(url, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                } else {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });

        // Auftragsdokument sichern/entsperren
        jQuery(document).on('click', '.specialtogglelock', function () {

            showLoadingSpinner();
            let currentClass = jQuery(this).find("i").attr('class');
            let documentid =  jQuery(this).data("orderdocument");
            let newLockState = 0;
            if(currentClass == "fas fa-lock-open-alt")
            {
                // Sichern
                jQuery(this).find("i").removeClass("fa-lock-open-alt").addClass("fas fa-lock-alt");
                newLockState = 1;
            }
            else if(currentClass == "fas fa-lock-alt")
            {
                // Entsichern
                jQuery(this).find("i").removeClass("fa-lock-alt").addClass("fas fa-lock-open-alt");
            }

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/orderdocuments/lock';
            var data = {};
            data["documentid"] = documentid;
            data["newLockState"] = newLockState;

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {

                    // Erfolgsmeldung anzeigen
                    hideLoadingSpinner();
                    if(newLockState == 1)
                    {
                        $description = "Die Datei kann nur noch vom Eigentümer oder berechtigten Personen eingesehen werden.";
                        showModalBox("Das Dokument wurde erfolgreich gesichert.", $description);
                    }
                    else {
                        showModalBox("Das Dokument wurde entsperrt.", "");
                    }
                } else {
                    errorFunction(response);
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                hideLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);
        });

        // Wiedervorlage löschen
        jQuery(document).on('click', '.deleteOrderFollowUp', function () {

            showLoadingSpinner();

            let followupid = jQuery(this).data("followupid");

            // AJAX-Request zum Versenden der E-Mail starten
            // Ajax-Parameter festlegen
            var url = '/followups/asyncDestroy';
            var data = {};
            data["followupid"] = followupid;

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {

                    // Erfolgsmeldung anzeigen
                    jQuery("#loadingSpinner").hide();
                    showModalBox("Wiedervorlage gelöscht.", "");
                    jQuery("#listEditor").removeClass();
                    jQuery("#listOverlay").hide();

                    // Eintrag aus Liste ausblenden
                    jQuery(".listItem[data-followupid=" + followupid + "]").remove();
                } else {
                    errorFunction(response);
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (response) {
                showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                hideLoadingSpinner();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);
        });


        // Gutschrift hinzufügen
        jQuery("#addCreditNote").click(function () {
            showLoadingSpinner();
            let url = "/creditnotes/edit/0";

            $.get(url, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);

                    // Vorbelegen der E-Vergabe
                    if(jQuery("[data-ordertype][data-ordertag=5] input[type=text]").length)
                    {
                        if(jQuery("#modifyOrderCreditNote input[name=fetch_number]").val() == "") {
                            jQuery("#modifyOrderCreditNote input[name=fetch_number]").val(
                                jQuery("[data-ordertype][data-ordertag=5] input[type=text]").val()
                            );
                        }
                    }

                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                } else {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });

        // Gutschrift bearbeiten
        jQuery(document).on('click', '.editCreditNote', function () {

            let creditNoteID = jQuery(this).data("creditnoteindex");
            let creditNoteExisted = jQuery(this).data("creditnoteexisted");

            showLoadingSpinner();
            let url = "/creditnotes/edit/0";

            $.get(url, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);

                    // Editierkennzeichen, Gutschrift-ID und Löschfeld setzen
                    jQuery("input#creditNoteEdit").val("true");
                    jQuery("input#creditNoteID").val(creditNoteID);
                    jQuery("input#creditNoteExisted").val(creditNoteExisted);

                    // Daten aus zugehörigem Input holen
                    let jsonCreditNoteData = jQuery("input[data-creditnoteindex=" + creditNoteID + "]").val();
                    let creditNoteData = JSON.parse(jsonCreditNoteData);

                    // Felder vorbelegen
                    jQuery("input#date").val(convertTimestampToHTMLDateString(creditNoteData.date));
                    jQuery("input#credit_note_number").val(creditNoteData.credit_note_number);
                    jQuery("input#reference_number").val(creditNoteData.reference_number);
                    var wert = creditNoteData.credit_note_value;
                    wert = (wert.toString()).replace(".",",");
                    jQuery("input#credit_note_value").val(wert);
                    jQuery("input#credit_note_end_date").val(convertTimestampToHTMLDateString(creditNoteData.end_date));
                    jQuery("input#fetch_number").val(creditNoteData.fetch_number);

                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                } else {
                    showModalBox("Es ist ein Fehler aufgetreten.", data.message);
                    hideLoadingSpinner();
                }
            });
        });

        // Neue Gutschrift verarbeiten
        jQuery(document).on('click', 'button#addOrderCreditNote', function () {

            // Eingabe validieren
            if (!jQuery("form#modifyOrderCreditNote").valid()) {
                showModalBox("Validierungsfehler", "Bitte Eingaben überprüfen.")
                return;
            }


            // Editierkennzeichen lesen
            let edit = jQuery("input#creditNoteEdit").val();

            // Daten für eine neue Gutschrift aus dem Overlay holen und als JSON-Objekt speichern
            let newCreditNote = {};

            newCreditNote.date = jQuery("input#date").val();
            newCreditNote.creditNoteExisted = jQuery("input#creditNoteExisted").val();
            newCreditNote.credit_note_number = jQuery("input#credit_note_number").val();
            newCreditNote.reference_number = jQuery("input#reference_number").val();
            newCreditNote.credit_note_value = jQuery("input#credit_note_value").val();
            newCreditNote.end_date = jQuery("input#credit_note_end_date").val();
            newCreditNote.fetch_number = jQuery("input#fetch_number").val();

            let jsonString = JSON.stringify(newCreditNote);

            let newIndex = 0;

            if (edit === "true") {
                let creditNoteId = jQuery("input#creditNoteID").val();

                // Bestehendes Input mit dieser Gutschrift-ID löschen
                jQuery("input[data-creditnoteindex='" + creditNoteId + "']").remove();

                // Listeneintrag löschen
                jQuery("div.listItem[data-creditnoteindex='" + creditNoteId + "']").remove();

                newIndex = creditNoteId;
            } else {
                // Letzten Gutschriftenindex finden
                let i = 0;

                jQuery("#creditNoteInputsHidden > input[data-creditnoteindex]").each(function () {
                    if (i <= jQuery(this).data("creditnoteindex")) {
                        i = jQuery(this).data("creditnoteindex");
                    }
                });

                // Neuen Index bestimmen
                newIndex = i + 1;
            }

            let newCreditNoteInput = "<input type='hidden' data-creditnoteindex='" + newIndex + "' " +
                "                         name='creditNote[" + newIndex + "]' value='" + jsonString + "'>";

            // JSON-String in unsichtbarem Input hinzufügen
            jQuery("#creditNoteInputsHidden").append(newCreditNoteInput);

            // Listeneintrag bauen
            // Gutschrift zur Liste hinzufügen
            let creditNoteItem = '<div class="row no-gutters listItem"\n' +
                '                                         data-creditnoteindex="' + newIndex + '"\n' +
                '                                         data-creditnoteexisted="false">\n' +
                '                                        <div class="col-1">\n' +
                '                                            ' + formatDateStringToReadableDate(newCreditNote.date) + '\n' +
                '                                        </div>\n' +
                '                                        <div class="col-2 text-right">\n' +
                '                                            ' + newCreditNote.fetch_number + '\n' +
                '                                        </div>\n' +
                '                                        <div class="col-2 text-right">\n' +
                '                                            ' + newCreditNote.credit_note_number + '\n' +
                '                                        </div>\n' +
                '                                        <div class="col-2 text-right">\n' +
                '                                            ' + newCreditNote.reference_number + '\n' +
                '                                        </div>\n' +
                '                                        <div class="col-2 text-right">\n' +
                '                                            ' + newCreditNote.credit_note_value + ' €\n' +
                '                                        </div>\n' +
                '                                        <div class="col-2  text-right">\n' +
                '                                            ' + formatDateStringToReadableDate(newCreditNote.end_date) + '\n' +
                '                                        </div>\n' +
                '                                        <div class="col-1">\n' +
                '                                            <div class="row align-items-center actions">\n' +
                '                                                <div class="col-6">\n' +
                '                                                    <a class="editCreditNote cursorPointer"\n' +
                '                                                       data-creditnoteindex="' + newIndex + '"\n' +
                '                                                       data-creditnoteexisted="' + newCreditNote.creditNoteExisted + '"\n' +
                '                                                    ><i class="fas fa-pencil-alt"></i></a>\n' +
                '                                                </div>\n' +
                '\n' +
                '                                                <div class="col-6">\n' +
                '                                                    <a class="deleteCreditNote cursorPointer"\n' +
                '                                                       data-creditnoteindex="' + newIndex + '"\n' +
                '                                                       data-creditnoteexisted="' + newCreditNote.creditNoteExisted + '"\n' +
                '                                                    ><i class="fas fa-trash-alt"></i></a>\n' +
                '                                                </div>\n' +
                '                                            </div>\n' +
                '                                        </div>\n' +
                '                                    </div>\n';

            jQuery("#closeListEditor").trigger("click");

            jQuery("#noListEntries").fadeOut();

            jQuery("#creditNoteEntries").prepend(creditNoteItem);
            jQuery("#creditNoteEntries #noListEntries").fadeOut();

        });


        // Gutschrift löschen
        jQuery(document).on('click', '.deleteCreditNote', function () {
            let creditNoteId = jQuery(this).data("creditnoteindex");

            // Input mit dieser Adress-ID auslesen
            let jsonString = jQuery("input[data-creditnoteindex='" + creditNoteId + "']").val();
            let creditNoteData = JSON.parse(jsonString);

            // Löschen-Flag nur setzen, wenn Adresse schon in der Datenbank existiert hat
            if (creditNoteData.creditNoteExisted === true) {
                creditNoteData.deleteCreditNote = true;

                // Input-Wert aktualisieren
                jsonString = JSON.stringify(creditNoteData);
                jQuery("input[data-creditnoteindex='" + creditNoteId + "']").val(jsonString);
            }
            // Ansonsten Input-Feld einfach löschen
            else {
                jQuery("input[data-creditnoteindex='" + creditNoteId + "']").remove();
            }

            // Listeneintrag wegblenden
            jQuery("div.listItem[data-creditnoteindex='" + creditNoteId + "']").addClass("markAsDeleted");
            jQuery("div.listItem[data-creditnoteindex='" + creditNoteId + "'] a").remove();
            jQuery("div.listItem[data-creditnoteindex='" + creditNoteId + "'] .actions").append("<i class=\"fas fa-minus-circle\"></i>");
        });


        // Duplikatsprüfung
        jQuery(".additionalOrderSubmit").click(function () {
            showLoadingSpinner();

            let url = "/orders/duplicate";

            // Ajax-Request für das Nachladen des Overlay-Forms vorbereiten
            var token = jQuery('meta[name="csrf-token"]').attr('content');
            jQuery.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            $.post(url, jQuery("#editOrder").serialize(), function (data) {

                if (data.response == "error") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    if (data.response != "duplicateExists")
                    {
                        jQuery("#editOrder").submit();
                        hideLoadingSpinner();
                    }
                    else
                    {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                }
            });
        });

    </script>
@endsection
