@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
?>

@section('content')
    <main class="contentContainer">

        <h1>Bezahlstatus</h1>

        <div class="row">
            <div class="col-12 col-md-3 text-md-center">
                @if(UserController::checkRight("createOrderPaymentStatus", $user))
                    <a class="button editOrderPaymentStatus"
                       href="#"
                       data-paymentstatusid="0">Neuen Bezahlstatus anlegen</a>
                @endif
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-10">
                        Bezahlstatus
                    </div>
                    <div class="col-2">
                        Aktionen
                    </div>
                </div>
                @if(count($orderPaymentStatus) > 0)
                    @foreach($orderPaymentStatus as $orderPaymentStatusItem)
                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-10 label">
                                {{ $orderPaymentStatusItem->label }}
                            </div>

                            <div class="col-2">
                                <div class="row no-gutters">

                                    <div class="">
                                        @if(UserController::checkRight("editOrderPaymentStatus", $user))
                                            <a href="#"
                                               data-paymentstatusid="{{ $orderPaymentStatusItem->id }}"
                                               class="editOrderPaymentStatus"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteOrderPaymentStatus", $user))
                                            <a href="#"
                                               data-paymentstatusid="{{ $orderPaymentStatusItem->id }}"
                                               class="deleteOrderPaymentStatus"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Bezahlstatus hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <script>
        jQuery(function () {
            // Bezahlstatus anlegen/bearbeiten: Overlay öffnen
            jQuery(".editOrderPaymentStatus").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/paymentstatus';
                var data = {};
                data["paymentStatusId"] = jQuery(this).data("paymentstatusid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);
            });


            // Bezahlstatus löschen: Overlay öffnen
            jQuery(".deleteOrderPaymentStatus").click(function () {
                showLoadingSpinner();

                // Ajax-Parameter festlegen
                var url = '/conf/paymentstatus/deleteConfirm';
                var data = {};
                data["paymentStatusId"] = jQuery(this).data("paymentstatusid");

                // Handling für erfolgreichen Request
                successFunction = function (response) {
                    if (response.response == "success") {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(response.editorHTML);
                        jQuery("#listEditor").addClass("windowModal");
                        jQuery("#listEditor").fadeIn();
                    }
                    else {
                        errorFunction(response);
                    }
                };

                // Handling für fehlerhaften Request
                errorFunction = function (response) {
                    showModalBox("Es ist ein Fehler aufgetreten.", response.message);
                    hideLoadingSpinner();
                };

                // Ajax aufrufen
                fireAjax(url, data, successFunction, errorFunction);

            });
        });
    </script>
@endsection
