<?php

use App\Http\Controllers\UserController;

if ($orderStatus->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Auftragsstatus @if($mode=="create") anlegen @elseif($mode=="edit") bearbeiten @endif</header>

<div class="container">

    @if($mode=="create")
        {!! BootForm::open(["id" => "editOrderStatus",
                             "route" => "orderStatus.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @elseif($mode=="edit")
        {!! BootForm::open(["id" => "editOrderStatus",
                             "route" => array("orderStatus.update", $orderStatus->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @endif


    <div class="form-group row">
        <label for="label" class="col-12 col-lg-4 col-form-label">Auftragsstatus</label>
        <div class="col-12 col-lg-8">
            <input type="text" class="form-control" id="label" name="label"
                   value="{{ $orderStatus->label }}">
        </div>
    </div>

    {!! BootForm::close() !!}
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editOrderStatus" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>


{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif

