@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
use App\Textblock;
?>

@section('content')
    <main class="contentContainer">

        <h1>Artikel / Dienstleistungen</h1>

        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12 col-md-3 text-md-center">
                        @if(UserController::checkRight("createProducts", $user))
                            <a class="button editProduct"
                               href="#"
                               data-productid="0">Neuen Artikel anlegen</a>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="clearfix">&nbsp;</div>

        <div class="row no-gutters" data-itable='1'>
            <div class="col-12">
                <div class="row no-gutters listHeader">
                    <div class="col-2">
                        Art-Nr.
                    </div>
                    <div class="col-4">
                        Bezeichnung
                    </div>
                    <div class="col-1 text-right">
                        Preis 1
                    </div>
                    <div class="col-1 text-right">
                        Preis 2
                    </div>
                    <div class="col-1 text-right">
                        Preis 3
                    </div>
                    <div class="col-1 text-right">
                        Preis 4
                    </div>
                </div>
                @if(count($products) > 0)
                    @foreach($products as $product)

                        <div class="row no-gutters align-items-center listItem">

                            <div class="col-2 label">
                                <a data-productid="{{ $product->id }}"
                                   class="editProduct cursorPointer"
                                   title="Bearbeiten">{{ $product->product_number }}</a>
                            </div>

                            <div class="col-4" style="word-break: break-word; padding-right: 10px;">
                                {{ $product->name }}
                            </div>

                            <div class="col-1 text-right">
                                {{ $product->price_1 }}
                            </div>
                            <div class="col-1 text-right">
                                {{ $product->price_2 }}
                            </div>
                            <div class="col-1 text-right">
                                {{ $product->price_3 }}
                            </div>
                            <div class="col-1 text-right">
                                {{ $product->price_4 }}
                            </div>

                            <div class="col-1">
                            </div>

                            <div class="col-1">
                                <div class="row no-gutters">
                                    <div class="">
                                        @if(UserController::checkRight("editProducts", $user))
                                            <a href="#"
                                               data-productid="{{ $product->id }}"
                                               class="editProduct"
                                               title="Bearbeiten">
                                                <i class="fal fa-pencil-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                    <div class="">
                                        @if(UserController::checkRight("deleteProducts", $user))
                                            <a href="#"
                                               data-productid="{{ $product->id }}"
                                               class="deleteProduct"
                                               title="Löschen">
                                                <i class="fal fa-trash-alt"></i>
                                            </a>
                                        @endif
                                    </div>

                                </div>
                            </div>

                        </div>
                    @endforeach
                @else
                    <div id="noListEntries" class="row">
                        <div class="col-12 text-center">
                            Keine Produkte hinterlegt.
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </main>

    @include('layouts.overlay')

    <script>
        // Neuen Textbaustein anlegen / Bestehenden bearbeiten
        jQuery(".editProduct").click(function () {
            showLoadingSpinner();

            let url = "/conf/product";
            let product_id = jQuery(this).data("productid");

            $.get(url + '/' + product_id, function (data) {

                if (data.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    error = true;
                    showModalBox("Es ist ein Fehler aufgetreten.");
                }
            });
        });

        // Textbaustein löschen: Overlay öffnen
        jQuery(".deleteProduct").click(function () {
            showLoadingSpinner();

            // Ajax-Parameter festlegen
            var url = '/conf/products/deleteConfirm';
            var data = {};
            data["productId"] = jQuery(this).data("productid");

            // Handling für erfolgreichen Request
            successFunction = function (response) {
                if (response.response == "success") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(response.editorHTML);
                    jQuery("#listEditor").addClass("windowModal");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    errorFunction();
                }
            };

            // Handling für fehlerhaften Request
            errorFunction = function (jqXHR, textStatus, errorThrown) {
                //console.log(JSON.stringify(jqXHR));
                //console.log("AJAX error: " + textStatus + ' : ' + errorThrown);

                jQuery("#loadingSpinner").hide();
                showModalBox("Es ist ein Fehler aufgetreten.");
                jQuery("#listEditor").removeClass();
                jQuery("#listOverlay").hide();
            };

            // Ajax aufrufen
            fireAjax(url, data, successFunction, errorFunction);

        });
    </script>


@endsection
