<?php

use App\Textblock;

if ($textblock->id == NULL) $mode = "create";
else $mode = "edit";

?>

<header>Textbaustein @if($mode=="create") anlegen @elseif($mode=="edit") bearbeiten @endif</header>


<div class="container">
    @if($mode=="create")
        {!! BootForm::open(["id" => "editTextblock",
                             "route" => "textblocks.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @elseif($mode=="edit")
        {!! BootForm::open(["id" => "editTextblock",
                             "route" => array("textblocks.update", $textblock->id),
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}
    @endif


    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="subject">Betreff</label>
                <input type="text" name="subject" id="subject" class="form-control" value="{{ $textblock->subject }}">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <label for="text">Text</label>
                <textarea name="text" id="text" name="text" class="form-control"
                          rows="7">{{ $textblock->text }}</textarea>
            </div>
        </div>
    </div>

    @if($textblock->hasPlaceholders == true)
        <div class="alert alert-danger">
            <div class="alertIcon">
                <i class="far fa-exclamation-circle"></i>
            </div>
            <div>
                Die Platzhalter dürfen nicht verändert werden, da sonst die E-Mail nicht mehr korrekt formatiert werden
                kann!
            </div>
        </div>
    @endif
</div>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="editTextblock" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

{!! BootForm::close() !!}

{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif

