<?php
use Carbon\Carbon;

if ($orderCreditNote->id == NULL) $mode = "create";
else $mode = "edit";

$today = Carbon::now()->toDateString();
?>


<header>Gutschrift @if($mode=="create") hinzufügen @elseif($mode=="edit") bearbeiten @endif</header>

<form id="modifyOrderCreditNote" action="javascript:void(0);">

    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="fetch_number">E-Vergabe</label>
                    <input type="text" name="fetch_number" id="fetch_number" class="form-control">
                </div>
            </div>
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="date">Eingangsdatum</label>
                    <input type="date" name="date" id="date" class="form-control" value="{{$today}}" max="9999-12-31">
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="credit_note_number">Gutschriftennummer</label>
                    <input type="text" name="credit_note_number" id="credit_note_number" class="form-control">
                </div>
            </div>
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="credit_note_value">Wert (EUR)</label>
                    <input type="text" name="credit_note_value" id="credit_note_value" class="form-control">
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="reference_number">Avis</label>
                    <input type="text" name="reference_number" id="reference_number" class="form-control">
                </div>
            </div>
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="credit_note_end_date">Datum Abgeschlossen</label>
                    <input type="date" name="credit_note_end_date" id="credit_note_end_date" class="form-control" max="9999-12-31">
                </div>
            </div>
        </div>


        <input type="hidden" id="creditNoteEdit" value="">
        <input type="hidden" id="creditNoteID" value="">
        <input type="hidden" id="creditNoteExisted" value="0">
    </div>
</form>

<footer>
    <div class="form-group row align-items-center">
        <div class="col-6 text-left">
            <button type="button" id="closeListEditorButton" class="btn btn-secondary">
                Abbrechen
            </button>
        </div>

        <div class="col-6 text-right">
            <button type="submit" form="addOrderLog" id="addOrderCreditNote" class="btn btn-primary">
                Speichern
            </button>
        </div>
    </div>
</footer>

{{--    Der JSValidator muss hier extra eingebaut werden, da Template asynchron geholt wird und der Code im Header-Bereich
        nicht generiert wird --}}
@if(isset($validator))
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
    @if (is_array($validator))
        @foreach($validator as $vali)
            {!! $vali !!}
        @endforeach
    @else
        {!! $validator !!}
    @endif
@endif