@extends('layouts.master')

<?php
use App\Http\Controllers\UserController;
use Carbon\Carbon;
use App\Library\DropzoneMulti;


$orderDocumentsDropzoneOptions = [
    'acceptedFiles' => '"image/*,application/pdf,application/msword,application/vnd.ms-powerpoint,application/vnd.ms-excel,.xlsx,.xls,.doc,.docx,.ppt,.pptx,.msg"',
    'maxFilesize' => 15,
    'maxFiles' => 15
];

$orderDocumentsDropzone = new DropzoneMulti(
    $orderDocumentsDropzoneOptions,
    "createOrder",
    "orderDocumentsDropzone",
    "default", true, "fas fa-file"
);

# Endtermin / Exporttermin bestimmen
$now = new Carbon();
$then = clone $now->addDays(28);
if ($then->isWeekend())
    $then->nextWeekDay();

?>

@section('content')
    <main class="contentContainer" id="app">
        <h1>Projekt anlegen</h1>
        <button type="button" class="btn btn-primary btn-big additionalOrderSubmit"
                style="position: absolute; right: 10px; top: 10px;">
            Projekt anlegen
        </button>

        {!! BootForm::open(["id" => "createOrder",
                             "route" => "projectArticleVariables.store",
                             "method" => "POST",
                             "enctype" => "multipart/form-data"]);
                             !!}

        <input type="hidden" name="projectToEdit" value="{{ $projectToEdit->id }}">



        <div class="row no-gutters listHeader">
            <div class="col-12">Artikeldaten</div>
        </div>

        <div class="col-12 orderTagsContainer">
            <div class="form-group">
                <div class="col-12">
                    <div style="display:flex;overflow:auto;">
                        <div class="orderTagsValueList" style="display:flex;flex-direction: column;overflow-y:unset;overflow-x:unset;min-width:unset;">
                            <div style="min-width:68vw;">
                            <div class="orderTagHeader" style="display:block;">
                                Variablen
                            </div>
                            <div class="orderTagsList" id="newOrderTags" style="display:block;">
                            </div>
                                <div class="orderTagsList" id="existingOrderTags" style="display:block;">
                                    <div class="orderTagValue" data-ordertype="0" style="display:flex;"
                                         data-ordertag="0">
                                        <div style="display: inline-block;width:200px;">
                                            <label class="checkbox">Artikelnummer
                                                <input type="checkbox" disabled="disabled"
                                                       name="ordertags[0]"
                                                       checked="checked" tabindex=-1
                                                       data-ordertag="0"
                                                >
                                                <span class="checkmark"></span>
                                            </label>
                                        </div>
                                        <div style="display: inline-block;width:150px;margin-right:10px;">
                                            <input type="text" name="ordertagsValues[0][0]"
                                                   value="" style="width:150px;">
                                        </div>
                                            <button id="addArticleButton" tabindex=-1 type="button" style="border:none;background:none;cursor:pointer;font-size:1.2em;color:#8cc0d5;margin-bottom:6px;"><i class="fas fa-plus-circle"></i></button>

                                    </div>
                                    @foreach($variables as $variable)
                                        <div class="orderTagValue" data-ordertype="0" style="display:flex;"
                                             data-ordertag="{{ $variable->id }}">
                                            <div style="display: inline-block;width:200px;">
                                                <label class="checkbox">{{ $variable->title }}
                                                    <input type="checkbox" tabindex=-1
                                                           name="ordertags[{{ $variable->id }}]"
                                                           data-ordertag="{{ $variable->id }}"
                                                    >
                                                    <span class="checkmark"></span>
                                                </label>
                                            </div>
                                            <div style="display: inline-block;width:150px;margin-right:10px;">
                                                <input type="text" name="ordertagsValues[{{ $variable->id }}][0]"
                                                       value="" style="width:150px;" onkeyup="CheckVariableCheckbox(this);">
                                            </div>
                                        </div>
{{--                                        <input type="hidden" name="variableId[]">--}}
                                    @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {!! BootForm::close() !!}

        <div class="row">
            <div class="col-12 text-right">
                <button type="button" class="btn btn-primary btn-big additionalOrderSubmit" style="margin-right:10px;">
                    Projekt anlegen
                </button>
            </div>
        </div>
    </main>

    @include('layouts.overlay')


    <?php
    echo $orderDocumentsDropzone->getDropzoneJSCode();
    ?>
    <script>

        // Bei Input in ein Variablen-Feld wird die entsprechende Checkbox der Variable automatisch angehakt
        function CheckVariableCheckbox(element)
        {
            //Zurückspringen in den Hauptcontainer der Variable und heraussuchen der entsprechenden Checkbox

            if($(element).val() == undefined || $(element).val().length <= 0) {
                // $(element).parent().parent().children("div:first").children("label:first").children('input').prop("checked", false);
            }
            else {
                $(element).parent().parent().children("div:first").children("label:first").children('input').prop("checked", "checked");
            }
        }

        jQuery(document).ready(function () {

            jQuery(document).on('click', '#addArticleButton', function(){
                var variableList = jQuery('.orderTagValue');
                variableList.each(function(index, element){
                    var lastDiv = $(element).children('div').last();
                    var newDiv = lastDiv.clone();
                    var input = newDiv.children('input')[0];
                    input.name = input.name.substr(0, input.name.lastIndexOf("[") + 1) + ($(element).children('div').length - 1) + "]";
                    newDiv.insertAfter(lastDiv);
                });
            });

            // Modifizierung der Auftragskennzeichen: Klick auf bereits zugewiesenes Kennzeichen
            jQuery(document).on('click', '#existingOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Input-Feld leeren und Kennzeichen in "Weitere Kennzeichen" verschieben
                jQuery("#existingOrderTags .orderTagValue[data-ordertag=" + orderTagId + "] input[type=text]").val("");
                // jQuery("#existingOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#additionalOrderTags");

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Modifizierung der Auftragskennzeichen: Klick auf neues Kennzeichen
            jQuery(document).on('click', '#additionalOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Kennzeichen in "Neue Kennzeichen" verschieben
                // jQuery("#additionalOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").appendTo("#newOrderTags");

                jQuery("#newOrderTags").fadeIn();
                jQuery(".orderTagHeader.newOrderTags").fadeIn();

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Modifizierung der Auftragskennzeichen: Klick auf neu hinzugefügtes Kennzeichen
            jQuery(document).on('click', '#newOrderTags input[type=checkbox]', function () {
                let orderTagId = jQuery(this).data("ordertag");

                // Input-Feld leeren und Kennzeichen in "Weitere Kennzeichen" verschieben
                jQuery("#newOrderTags .orderTagValue[data-ordertag=" + orderTagId + "] input[type=text]").val("");
                jQuery("#newOrderTags .orderTagValue[data-ordertag=" + orderTagId + "]").prependTo("#additionalOrderTags");

                // Wenn keine neu hinzugefügten Kennzeichen mehr da sind, Header ausblenden
                if (jQuery("#newOrderTags > *").length <= 0) {
                    jQuery(".orderTagHeader.newOrderTags").fadeOut();
                }

                // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
                jQuery("input#orderTagsChanged").val("1");
            });

            // Beim Tippen in ein Auftragskennzeichenwertefeld  // Kennzeichen setzen, dass Auftragskennzeichen modifiziert wurden
            jQuery("input[name^=ordertagsValues]").change(function () {
                jQuery("input#orderTagsChanged").val("1");
            });
        });


        // Duplikatsprüfung
        jQuery(".additionalOrderSubmit").click(function () {
            showLoadingSpinner();

            let url = "/orders/duplicate";

            // Ajax-Request für das Nachladen des Overlay-Forms vorbereiten
            var token = jQuery('meta[name="csrf-token"]').attr('content');
            jQuery.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            $.post(url, jQuery("#createOrder").serialize(), function (data) {
                if (data.response == "error") {
                    jQuery("#loadingSpinner").hide();
                    jQuery("#editorContent").html(data.editorHTML);
                    jQuery("#listEditor").addClass("windowNarrow");
                    jQuery("#listEditor").fadeIn();
                }
                else {
                    if (data.response != "duplicateExists")
                    {
                        jQuery("#createOrder").submit();
                        hideLoadingSpinner();
                    }
                    else
                    {
                        jQuery("#loadingSpinner").hide();
                        jQuery("#editorContent").html(data.editorHTML);
                        jQuery("#listEditor").addClass("windowNarrow");
                        jQuery("#listEditor").fadeIn();
                    }
                }
            });
        });

    </script>
@endsection
